/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.javascript.core.dom.Identifier;

class ParameterData {
    private Identifier declaration;
    private int accessMode;
    private boolean function = false;
    private List<Identifier> references;

    public ParameterData(Identifier decl) {
        this.declaration = decl;
        this.accessMode = 1;
        this.references = new ArrayList<Identifier>();
    }

    public String getName() {
        return this.declaration.getName();
    }

    public void addReference(Identifier node) {
        this.references.add(node);
    }

    public List<Identifier> references() {
        return this.references;
    }

    public void setAccessMode(int mode) {
        this.accessMode = mode;
    }

    public boolean isReadOnly() {
        return (this.accessMode & 6) != 0;
    }

    public boolean isWrite() {
        return (this.accessMode & 0x38) != 0;
    }

    public int getSimplifiedAccessMode() {
        if (this.isWrite()) {
            return 8;
        }
        if (this.isReadOnly()) {
            return 2;
        }
        return 1;
    }

    public int getNumberOfAccesses() {
        return this.references.size();
    }

    public void setFunction(boolean value) {
        this.function = value;
    }

    public boolean isFunction() {
        return this.function;
    }
}

