/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.SwitchComponent;

public class CaseClause
extends SwitchComponent {
    private Keyword caseKeyword;
    private Expression condition;

    public CaseClause(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            List<Statement> statements;
            if (this.caseKeyword != null) {
                this.caseKeyword.traverse(visitor);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if ((statements = this.getStatements()) != null) {
                for (Statement statement : statements) {
                    statement.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Keyword getCaseKeyword() {
        return this.caseKeyword;
    }

    public void setCaseKeyword(Keyword keyword) {
        this.caseKeyword = keyword;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("case");
        buffer.append(" ");
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(":\n");
        CaseClause.toSourceString(this.getStatements(), buffer, String.valueOf(indentationString) + "    ");
        return buffer.toString();
    }

    @Override
    public Keyword getKeyword() {
        return this.getCaseKeyword();
    }
}

