/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ThisValue;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.typeinference.IFunctionValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.RTypes;

public class FunctionValueCollection
extends ValueCollection
implements IFunctionValueCollection {
    private final String functionName;
    private final boolean block;
    private final IValueReference returnValue = new AnonymousValue();
    private final IValueReference thisValue;

    public FunctionValueCollection(IValueCollection parent, String functionName) {
        this(parent, functionName, false);
    }

    public FunctionValueCollection(IValueCollection parent, String functionName, boolean block) {
        this(parent, functionName, new ThisValue(), block);
    }

    public FunctionValueCollection(IValueCollection parent, String functionName, IValueReference thisValue, boolean block) {
        super(parent);
        this.functionName = functionName;
        this.thisValue = thisValue;
        this.block = block;
        IValueReference arguments = this.createChild("arguments");
        arguments.setKind(ReferenceKind.LOCAL);
        IValueReference argumentsLength = arguments.getChild("length");
        argumentsLength.setDeclaredType(RTypes.NUMBER);
        IValueReference argumentsArray = arguments.getChild("[]");
        argumentsArray.setDeclaredType(RTypes.OBJECT);
    }

    @Override
    public boolean isInlineBlock() {
        return this.block;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean isScope() {
        return true;
    }

    @Override
    public IValueReference getReturnValue() {
        return this.returnValue;
    }

    @Override
    public IValueReference getThis() {
        return this.thisValue;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "<" + this.functionName + ">";
    }
}

