/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ExtractTempWizard;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExtractTempAction
implements IEditorActionDelegate {
    private ScriptEditor editor;
    private ITextSelection selection;

    public void run(IAction action) {
        try {
            if (!ActionUtil.isEditable((ITextEditor)this.editor)) {
                return;
            }
            ExtractTempRefactoring refactoring = new ExtractTempRefactoring(SelectionConverter.getInputAsSourceModule((IEditorPart)this.editor), this.selection.getOffset(), this.selection.getLength());
            new RefactoringStarter().activate((Refactoring)refactoring, (RefactoringWizard)new ExtractTempWizard(refactoring), this.editor.getEditorSite().getShell(), RefactoringMessages.ExtractTempAction_extract_temp, false);
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof ITextSelection ? (ITextSelection)selection : null;
        this.checkEnabled(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ScriptEditor ? (ScriptEditor)targetEditor : null;
        this.checkEnabled(action);
    }

    private void checkEnabled(IAction action) {
        action.setEnabled(this.selection != null && SelectionConverter.getInputAsSourceModule((IEditorPart)this.editor) != null);
    }
}

