/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;

public class RemoveSourceModuleRequest
extends AbstractIndexRequest {
    private final IPath containerPath;
    private final String relativePath;

    public RemoveSourceModuleRequest(ProjectIndexer2 indexer, IPath containerPath, String relativePath, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.containerPath = containerPath;
        this.relativePath = relativePath;
    }

    @Override
    protected String getName() {
        return this.containerPath.append(this.relativePath).toString();
    }

    @Override
    protected void run() throws CoreException, IOException {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null || this.isCancelled) {
            return;
        }
        indexer.removeDocument(this.containerPath, this.relativePath);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.containerPath == null ? 0 : this.containerPath.hashCode());
        result = 31 * result + (this.relativePath == null ? 0 : this.relativePath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveSourceModuleRequest other = (RemoveSourceModuleRequest)obj;
        if (this.containerPath == null ? other.containerPath != null : !this.containerPath.equals((Object)other.containerPath)) {
            return false;
        }
        return !(this.relativePath == null ? other.relativePath != null : !this.relativePath.equals(other.relativePath));
    }
}

