/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class AssignmentRule
implements IRule {
    private final StringBuffer buffer = new StringBuffer();
    private final IToken defaultToken;
    private final IWordDetector detector;
    private final IToken successToken;

    public AssignmentRule(IWordDetector detector, IToken defaultToken, IToken token) {
        this.detector = detector;
        this.successToken = token;
        this.defaultToken = defaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char c = (char)scanner.read();
        if (this.detector.isWordStart(c)) {
            this.buffer.setLength(0);
            do {
                this.buffer.append(c);
            } while ((c = (char)scanner.read()) != '\uffffffff' && this.detector.isWordPart(c));
            scanner.unread();
            if (c == '=') {
                return this.successToken;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

