/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class ProjectFragmentContainer
implements IAdaptable {
    private static WorkbenchAdapterImpl fgAdapterInstance = new WorkbenchAdapterImpl();
    private IScriptProject fProject;

    public ProjectFragmentContainer(IScriptProject project) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return (T)fgAdapterInstance;
        }
        return null;
    }

    public abstract IAdaptable[] getChildren();

    public abstract IProjectFragment[] getProjectFragments();

    public abstract String getLabel();

    public abstract ImageDescriptor getImageDescriptor();

    public IScriptProject getScriptProject() {
        return this.fProject;
    }

    private static class WorkbenchAdapterImpl
    implements IWorkbenchAdapter {
        private WorkbenchAdapterImpl() {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof ProjectFragmentContainer) {
                return ((ProjectFragmentContainer)o).getChildren();
            }
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object o) {
            if (o instanceof ProjectFragmentContainer) {
                return ((ProjectFragmentContainer)o).getImageDescriptor();
            }
            return null;
        }

        public String getLabel(Object o) {
            if (o instanceof ProjectFragmentContainer) {
                return ((ProjectFragmentContainer)o).getLabel();
            }
            return new String();
        }

        public Object getParent(Object o) {
            if (o instanceof ProjectFragmentContainer) {
                return ((ProjectFragmentContainer)o).getScriptProject();
            }
            return null;
        }
    }
}

