/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.console;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.lsp.server.ILogProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public final class ClangdConsole
implements ILogProvider {
    private static final String CLANGD_CONSOLE = "Clangd";
    private OutputStream outputStream;

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = this.findConsole().newOutputStream();
        }
        return this.outputStream;
    }

    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (IOException e) {
                Platform.getLog(ClangdConsole.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = conMan.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole existing = iConsoleArray[n2];
            if (CLANGD_CONSOLE.equals(existing.getName())) {
                return (MessageConsole)existing;
            }
            ++n2;
        }
        MessageConsole myConsole = new MessageConsole(CLANGD_CONSOLE, null);
        myConsole.setWaterMarks(80000, 800000);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

