/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class SelectDRepresentationElementsListener
extends ResourceSetListenerImpl {
    private static final NotificationFilter DEFAULT_NOTIFICATION_FILTER = NotificationFilter.createFeatureFilter((EStructuralFeature)ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT).or(NotificationFilter.NOT_TOUCH.and(SessionEventBrokerImpl.asFilter((Predicate)DanglingRefRemovalTrigger.IS_ATTACHMENT)).and(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION).or(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT))));
    protected DialectEditor dialectEditor;
    private boolean selectOnlyViewWithNewSemanticTarget;
    private boolean enableCreatedElementsConstraintInSelectElementsListener = Boolean.valueOf(System.getProperty("org.eclipse.sirius.ui.enableCreatedElementsConstraintInSelectElementsListener", "true"));

    public SelectDRepresentationElementsListener(DialectEditor editor, boolean selectOnlyViewWithNewSemanticTarget) {
        this(editor, selectOnlyViewWithNewSemanticTarget, DEFAULT_NOTIFICATION_FILTER);
    }

    public SelectDRepresentationElementsListener(DialectEditor editor, boolean selectOnlyViewWithNewSemanticTarget, NotificationFilter filter) {
        super(filter != null ? filter : DEFAULT_NOTIFICATION_FILTER);
        TransactionalEditingDomain domain;
        this.dialectEditor = Objects.requireNonNull(editor);
        this.selectOnlyViewWithNewSemanticTarget = selectOnlyViewWithNewSemanticTarget;
        DRepresentation representation = editor.getRepresentation();
        if (representation != null && (domain = TransactionUtil.getEditingDomain((EObject)representation)) != null) {
            domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (!Boolean.TRUE.equals(event.getTransaction().getOptions().get("is_undo_redo_transaction"))) {
            DRepresentation currentRep = this.dialectEditor.getRepresentation();
            if (currentRep == null) {
                return;
            }
            Display display = Display.getCurrent();
            if (display != null && Thread.currentThread() == display.getThread()) {
                IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
                if (activeEditor != null) {
                    activeEditor = (IEditorPart)activeEditor.getAdapter(DialectEditor.class);
                }
                if (this.dialectEditor.equals(activeEditor)) {
                    List<DRepresentationElement> elementsToSelect = this.extractElementsToSelect(event, currentRep);
                    this.setSelectionInAsyncExec(this.dialectEditor, elementsToSelect);
                }
            } else {
                List<DRepresentationElement> elementsToSelect = this.extractElementsToSelect(event, currentRep);
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                executorService.submit(() -> {
                    IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
                    if (activeEditor != null) {
                        activeEditor = (IEditorPart)activeEditor.getAdapter(DialectEditor.class);
                    }
                    if (this.dialectEditor.equals(activeEditor)) {
                        this.setSelectionInAsyncExec(this.dialectEditor, elementsToSelect);
                    }
                });
            }
        }
    }

    protected void setSelectionInAsyncExec(DialectEditor currentDialectEditor, List<DRepresentationElement> elementsToSelect) {
        if (elementsToSelect != null) {
            EclipseUIUtil.displayAsyncExec((Runnable)new SetSelectionRunnable(currentDialectEditor, elementsToSelect));
        }
    }

    protected List<DRepresentationElement> extractElementsToSelect(ResourceSetChangeEvent event, DRepresentation currentRep) {
        UIState uiState;
        List<DRepresentationElement> elementsToSelectFromUiState;
        List<Object> elementsToSelect = null;
        ArrayList<DRepresentationElement> notifiedElements = new ArrayList<DRepresentationElement>();
        boolean elementsToSelectUpdated = this.analyseNotifications(event, currentRep, notifiedElements);
        elementsToSelect = elementsToSelectUpdated ? ((elementsToSelectFromUiState = this.extractSelectionFromUIState(currentRep, notifiedElements)) != null ? elementsToSelectFromUiState : (notifiedElements.size() > 0 ? notifiedElements : null)) : (notifiedElements.isEmpty() ? null : notifiedElements);
        if (elementsToSelect != null && !elementsToSelect.isEmpty() && (uiState = currentRep.getUiState()) != null && uiState.isInverseSelectionOrder()) {
            Collections.reverse(elementsToSelect);
        }
        return elementsToSelect;
    }

    private List<DRepresentationElement> extractSelectionFromUIState(DRepresentation currentRep, List<DRepresentationElement> notifiedElements) {
        ArrayList<Object> selectedElements = null;
        ArrayList<DRepresentationElement> dRepElements = new ArrayList<DRepresentationElement>();
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        UIState uiState = currentRep.getUiState();
        if (uiState != null && uiState.isSetElementsToSelect()) {
            EList elementsToSelectFromUIState = uiState.getElementsToSelect();
            boolean hasRepElement = false;
            boolean hasSemanticElement = false;
            boolean hasRepresentation = false;
            for (EObject currentElement : elementsToSelectFromUIState) {
                if (currentElement instanceof DRepresentationElement) {
                    hasRepElement = true;
                    dRepElements.add((DRepresentationElement)currentElement);
                    continue;
                }
                if (currentElement instanceof DRepresentation) {
                    hasRepresentation = true;
                    break;
                }
                hasSemanticElement = true;
                semanticElements.add(currentElement);
            }
            if (hasSemanticElement && !hasRepresentation && !hasRepElement) {
                selectedElements = new ArrayList();
                this.caseHasSemanticElement(selectedElements, notifiedElements, semanticElements, currentRep);
            } else if (hasRepElement && !hasRepresentation && !hasSemanticElement) {
                if (this.enableCreatedElementsConstraintInSelectElementsListener && !notifiedElements.isEmpty()) {
                    dRepElements.retainAll(notifiedElements);
                }
                selectedElements = new ArrayList(dRepElements);
            } else {
                selectedElements = new ArrayList<DRepresentationElement>();
            }
        }
        return selectedElements;
    }

    private void caseHasSemanticElement(List<DRepresentationElement> selectedElements, List<DRepresentationElement> notifiedElements, List<EObject> semanticElements, DRepresentation currentRep) {
        for (EObject semanticElement : semanticElements) {
            ArrayList<DRepresentationElement> repElementsFromSemantic = new ArrayList<DRepresentationElement>();
            EObjectQuery eObjectQuery = new EObjectQuery(semanticElement);
            Collection referencers = eObjectQuery.getInverseReferences(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET);
            for (EObject referencer : referencers) {
                if (!(referencer instanceof DRepresentationElement) || !currentRep.equals(new EObjectQuery(referencer).getRepresentation().get())) continue;
                repElementsFromSemantic.add((DRepresentationElement)referencer);
            }
            boolean notifiedElementsEmpty = notifiedElements.isEmpty();
            if (this.enableCreatedElementsConstraintInSelectElementsListener && !notifiedElementsEmpty) {
                for (DRepresentationElement elem : notifiedElements) {
                    if (!repElementsFromSemantic.contains(elem)) continue;
                    selectedElements.add(elem);
                }
                continue;
            }
            selectedElements.addAll(repElementsFromSemantic);
        }
    }

    protected boolean isViewWithNewSemanticTarget(Collection<EObject> attachedEObjects, DRepresentationElement view) {
        boolean isViewWithNewSemanticTarget = false;
        if (attachedEObjects != null && !attachedEObjects.isEmpty()) {
            isViewWithNewSemanticTarget = EcoreUtil.isAncestor(attachedEObjects, (EObject)view.getTarget());
        }
        return isViewWithNewSemanticTarget;
    }

    protected boolean analyseNotifications(ResourceSetChangeEvent event, DRepresentation currentRep, List<DRepresentationElement> keptNotifiedElements) {
        boolean elementsToSelectUpdated = false;
        EList attachedEObjects = null;
        for (Notification n : event.getNotifications()) {
            Object feature = n.getFeature();
            if (!ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT.equals(feature) && !ViewpointPackage.Literals.DREPRESENTATION__UI_STATE.equals(feature)) {
                Set<DRepresentationElement> notificationValues = this.getAttachmentNotificationValues(n);
                for (DRepresentationElement elt : notificationValues) {
                    if (currentRep != new DRepresentationElementQuery(elt).getParentRepresentation()) continue;
                    if (attachedEObjects == null && this.isSelectOnlyViewWithNewSemanticTarget()) {
                        TransactionChangeDescription changeDescription = event.getTransaction().getChangeDescription();
                        attachedEObjects = changeDescription.getObjectsToDetach();
                    }
                    if (this.isSelectOnlyViewWithNewSemanticTarget() && !this.isViewWithNewSemanticTarget((Collection<EObject>)attachedEObjects, elt) || EcoreUtil.isAncestor(keptNotifiedElements, (EObject)elt)) continue;
                    keptNotifiedElements.add(elt);
                }
                continue;
            }
            elementsToSelectUpdated = true;
        }
        return elementsToSelectUpdated;
    }

    protected Set<DRepresentationElement> getAttachmentNotificationValues(Notification notification) {
        LinkedHashSet<DRepresentationElement> values = new LinkedHashSet<DRepresentationElement>();
        Object value = notification.getNewValue();
        if (value instanceof Collection) {
            Iterables.addAll(values, (Iterable)Iterables.filter((Iterable)((Collection)value), DRepresentationElement.class));
        } else if (value instanceof DRepresentationElement) {
            values.add((DRepresentationElement)value);
        }
        return values;
    }

    protected boolean isSelectOnlyViewWithNewSemanticTarget() {
        return this.selectOnlyViewWithNewSemanticTarget;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }

    private static class SetSelectionRunnable
    implements Runnable {
        private final DialectEditor dialectEditor;
        private List<DRepresentationElement> newSelection;

        SetSelectionRunnable(DialectEditor dialectEditor, Collection<DRepresentationElement> elementsToSelect) {
            this.dialectEditor = dialectEditor;
            this.newSelection = new ArrayList<DRepresentationElement>(elementsToSelect);
        }

        @Override
        public void run() {
            DialectUIManager.INSTANCE.setSelection(this.dialectEditor, this.newSelection);
        }
    }
}

