/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.TopicStatus;
import org.eclipse.emf.cdo.lm.reviews.provider.TopicContainerItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class TopicItemProvider
extends TopicContainerItemProvider {
    public static final StyledString.Style STYLE_UNRESOLVED = StyledString.Style.newBuilder().setForegroundColor(URI.createURI((String)"color://rgb/220/40/40")).toStyle();
    public static final StyledString.Style STYLE_RESOLVED = StyledString.Style.newBuilder().setForegroundColor(URI.createURI((String)"color://rgb/20/180/20")).toStyle();
    private ItemPropertyDescriptor statusPropertyDescriptor;

    public TopicItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdPropertyDescriptor(object);
            this.addTextPropertyDescriptor(object);
            this.addAuthorPropertyDescriptor(object);
            this.addCreationTimePropertyDescriptor(object);
            this.addEditTimePropertyDescriptor(object);
            this.addHeadingPropertyDescriptor(object);
            this.addModelReferencePropertyDescriptor(object);
            this.addStatusPropertyDescriptor(object);
            this.addParentHeadingPropertyDescriptor(object);
            this.addPreviousHeadingPropertyDescriptor(object);
            this.addNextHeadingPropertyDescriptor(object);
            this.addOutlineNumberPropertyDescriptor(object);
            this.addParentIndexPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Authorable_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Authorable_id_feature", "_UI_Authorable_type"), (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__ID, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addTextPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Authorable_text_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Authorable_text_feature", "_UI_Authorable_type"), (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__TEXT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addHeadingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_heading_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_heading_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__HEADING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addModelReferencePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_modelReference_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_modelReference_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__MODEL_REFERENCE, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addStatusPropertyDescriptor(Object object) {
        this.statusPropertyDescriptor = this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_status_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_status_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__STATUS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null);
        this.itemPropertyDescriptors.add(this.statusPropertyDescriptor);
    }

    protected void addAuthorPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Authorable_author_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Authorable_author_feature", "_UI_Authorable_type"), (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__AUTHOR, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCreationTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Authorable_creationTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Authorable_creationTime_feature", "_UI_Authorable_type"), (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__CREATION_TIME, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addEditTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Authorable_editTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Authorable_editTime_feature", "_UI_Authorable_type"), (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__EDIT_TIME, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addParentHeadingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_parentHeading_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_parentHeading_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__PARENT_HEADING, false, false, false, null, null, null));
    }

    protected void addPreviousHeadingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_previousHeading_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_previousHeading_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__PREVIOUS_HEADING, false, false, false, null, null, null));
    }

    protected void addNextHeadingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_nextHeading_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_nextHeading_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__NEXT_HEADING, false, false, false, null, null, null));
    }

    protected void addOutlineNumberPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_outlineNumber_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_outlineNumber_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__OUTLINE_NUMBER, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addParentIndexPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Topic_parentIndex_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Topic_parentIndex_feature", "_UI_Topic_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC__PARENT_INDEX, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Topic"));
    }

    protected Object overlayImage(Object object, Object image) {
        image = super.overlayImage(object, image);
        return TopicContainerItemProvider.overlayTopicContainerImage((TopicContainer)((Topic)object), image);
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return ((StyledString)this.getStyledText(object)).getString();
    }

    @Override
    public Object getStyledText(Object object) {
        Topic topic = (Topic)object;
        StyledString styledString = new StyledString();
        if (topic.isHeading()) {
            styledString.append(topic.getOutlineNumber(), StyledString.Style.QUALIFIER_STYLER).append(" ");
        }
        styledString.append(topic.getText());
        StyledString.Style style = null;
        TopicStatus status = topic.getStatus();
        if (status == TopicStatus.UNRESOLVED) {
            style = STYLE_UNRESOLVED;
        } else if (status == TopicStatus.RESOLVED) {
            style = STYLE_RESOLVED;
        }
        if (style != null) {
            this.getPropertyDescriptors(topic);
            String statusLabel = this.statusPropertyDescriptor.getLabelProvider((Object)topic).getText((Object)status);
            styledString.append("  ").append("[" + statusLabel + "]", style);
        }
        return styledString;
    }

    @Override
    @Deprecated
    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Topic.class)) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Topic.class)) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                TopicContainerItemProvider.propagateNotification((ItemProviderAdapter)this, notification, notification.getNotifier());
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

