/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.dtd.core.internal.provisional.contenttype.ContentTypeIdForDTD;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.editor.IHelpContextIds;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class DTDFilesPreferencePage
extends AbstractPreferencePage {
    private Combo fDefaultSuffix = null;
    private List fValidExtensions = null;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IHelpContextIds.DTD_PREFWEBX_FILES_HELPID);
        Group creatingGroup = this.createGroup(composite, 2);
        creatingGroup.setText(DTDUIMessages.Creating_files);
        this.createLabel((Composite)creatingGroup, DTDUIMessages.DTDFilesPreferencePage_ExtensionLabel);
        this.fDefaultSuffix = this.createDropDownBox((Composite)creatingGroup);
        Object[] validExtensions = this.getValidExtensions().toArray(new String[0]);
        Arrays.sort(validExtensions);
        this.fDefaultSuffix.setItems((String[])validExtensions);
        this.fDefaultSuffix.addSelectionListener((SelectionListener)this);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    public void dispose() {
        this.fDefaultSuffix.removeModifyListener((ModifyListener)this);
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DTDUIPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        DTDCorePlugin.getInstance().savePluginPreferences();
    }

    private IContentType getContentType() {
        return Platform.getContentTypeManager().getContentType(ContentTypeIdForDTD.ContentTypeID_DTD);
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    protected Preferences getModelPreferences() {
        return DTDCorePlugin.getInstance().getPluginPreferences();
    }

    protected void initializeValues() {
        String suffix = this.getModelPreferences().getString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
    }

    protected void performDefaults() {
        String suffix = this.getModelPreferences().getDefaultString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected void storeValues() {
        String suffix = this.fDefaultSuffix.getText();
        this.getModelPreferences().setValue("defaultExtension", suffix);
    }

    protected void validateValues() {
        boolean isValid = false;
        Iterator i = this.getValidExtensions().iterator();
        while (i.hasNext() && !isValid) {
            String extension = (String)i.next();
            isValid = extension.equalsIgnoreCase(this.fDefaultSuffix.getText());
        }
        if (!isValid) {
            this.setErrorMessage(NLS.bind((String)DTDUIMessages.DTDFilesPreferencePage_ExtensionError, (Object)this.getValidExtensions().toString()));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

