/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.ContentModelPlugin;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.XMLValidator;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityResolver;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelDiagnosticsParticipant
implements IDiagnosticsParticipant {
    private final ContentModelPlugin contentModelPlugin;

    public ContentModelDiagnosticsParticipant(ContentModelPlugin contentModelPlugin) {
        this.contentModelPlugin = contentModelPlugin;
    }

    @Override
    public void doDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker monitor) {
        this.downloadExternalResourcesIfNeeded(diagnostics);
        if (xmlDocument.isDTD() || DOMUtils.isXSD(xmlDocument) || DOMUtils.isRelaxNG(xmlDocument)) {
            return;
        }
        URIResolverExtensionManager entityResolver = xmlDocument.getResolverExtensionManager();
        LSPXMLEntityResolver entityResolverWrapper = new LSPXMLEntityResolver(entityResolver, (DiagnosticsResult)diagnostics);
        XMLValidator.doDiagnostics(xmlDocument, entityResolverWrapper, diagnostics, validationSettings, this.contentModelPlugin.getContentModelManager(), monitor);
    }

    private void downloadExternalResourcesIfNeeded(List<Diagnostic> diagnostics) {
        Map<String, Object> validationArgs = ((DiagnosticsResult)diagnostics).getValidationArgs();
        String url = DownloadDisabledResourceCodeAction.getUrlToForceToDownload(validationArgs);
        if (url != null) {
            this.contentModelPlugin.getContentModelManager().forceDownloadExternalResource(url);
        }
    }
}

