/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.logconsole;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.internal.logconsole.LogConsoleFactoryManager;
import org.eclipse.dltk.internal.logconsole.NopLogConsole;
import org.eclipse.dltk.logconsole.ILogConsole;
import org.eclipse.dltk.logconsole.ILogConsoleManager;
import org.eclipse.dltk.logconsole.LogConsoleType;

public class LogConsoleManager
implements ILogConsoleManager {
    protected static final LogConsoleType DEFAULT_CONSOLE_TYPE = new LogConsoleType("org.eclipse.dltk.logconsole.DEFAULT");
    private final Object lock = new Object();
    private final Map<ConsoleKey, ILogConsole> consoles = new HashMap<ConsoleKey, ILogConsole>();

    @Override
    public ILogConsole getConsole(LogConsoleType consoleType) {
        return this.getConsole(consoleType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILogConsole getConsole(LogConsoleType consoleType, Object identifier) {
        ConsoleKey key = new ConsoleKey(consoleType, identifier);
        Object object = this.lock;
        synchronized (object) {
            ILogConsole console = this.consoles.get(key);
            if (console != null) {
                return console;
            }
        }
        ILogConsole console = this.createConsole(key);
        Object object2 = this.lock;
        synchronized (object2) {
            ILogConsole c = this.consoles.get(key);
            if (c != null) {
                this.disposeConsole(console);
                return c;
            }
            this.consoles.put(key, console);
        }
        return console;
    }

    private void disposeConsole(ILogConsole console) {
    }

    private ILogConsole createConsole(ConsoleKey key) {
        ILogConsole console = LogConsoleFactoryManager.getInstance().create(key.consoleType, key.identifier);
        if (console != null) {
            return console;
        }
        return new NopLogConsole(key.consoleType, key.identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILogConsole[] list(LogConsoleType consoleType) {
        ArrayList<ILogConsole> result = new ArrayList<ILogConsole>();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<ConsoleKey, ILogConsole> entry : this.consoles.entrySet()) {
                if (!consoleType.equals(entry.getKey().consoleType)) continue;
                result.add(entry.getValue());
            }
        }
        return result.toArray(new ILogConsole[result.size()]);
    }

    private static class ConsoleKey {
        final LogConsoleType consoleType;
        final Object identifier;

        public ConsoleKey(LogConsoleType consoleType, Object identifier) {
            this.consoleType = consoleType != null ? consoleType : DEFAULT_CONSOLE_TYPE;
            this.identifier = identifier;
        }

        public int hashCode() {
            int result = this.consoleType.hashCode();
            if (this.identifier != null) {
                result = result * 13 + this.identifier.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConsoleKey) {
                ConsoleKey other = (ConsoleKey)obj;
                if (this.consoleType.equals(other.consoleType)) {
                    return this.identifier != null ? this.identifier.equals(other.identifier) : other.identifier == null;
                }
            }
            return false;
        }
    }
}

