/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public final class SyntheticVariableUtils {
    private static final String ENCLOSING_INSTANCE_PREFIX = "this$";
    private static final String ANONYMOUS_VAR_PREFIX = "val$";

    private SyntheticVariableUtils() {
    }

    public static IVariable[] findSyntheticVariables(IVariable[] variables) throws DebugException {
        ArrayList<IVariable> extracted = new ArrayList<IVariable>();
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable variable = iVariableArray[n2];
            if (variable.getName().startsWith(ANONYMOUS_VAR_PREFIX)) {
                extracted.add(variable);
            }
            if (variable.getName().startsWith(ENCLOSING_INSTANCE_PREFIX)) {
                extracted.addAll(Arrays.asList(SyntheticVariableUtils.findSyntheticVariables(variable.getValue().getVariables())));
            }
            ++n2;
        }
        return extracted.toArray(new IVariable[extracted.size()]);
    }
}

