/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swtchart.extensions.model.ICustomSeries;

public class CustomSeriesComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof ICustomSeries) {
            ICustomSeries customSeries1 = (ICustomSeries)e1;
            if (e2 instanceof ICustomSeries) {
                ICustomSeries customSeries2 = (ICustomSeries)e2;
                switch (this.propertyIndex) {
                    case 0: {
                        sortOrder = customSeries1.getId().compareTo(customSeries2.getId());
                        break;
                    }
                    case 1: {
                        sortOrder = Boolean.compare(customSeries1.isDraw(), customSeries2.isDraw());
                        break;
                    }
                    case 2: {
                        sortOrder = customSeries1.getLabel().compareTo(customSeries2.getLabel());
                        break;
                    }
                    case 3: {
                        sortOrder = customSeries1.getDescription().compareTo(customSeries2.getDescription());
                        break;
                    }
                    default: {
                        sortOrder = 0;
                    }
                }
            }
        }
        if (this.direction == 1) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

