/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.prov.engine.Messages;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.Profile;
import org.eclipse.osgi.util.NLS;

public abstract class Phase {
    protected final String phaseId;
    protected final int weight;
    protected final String phaseName;

    protected Phase(String phaseId, int weight, String phaseName) {
        if (phaseId == null || phaseId.length() == 0) {
            throw new IllegalArgumentException("Phase id must be set.");
        }
        if (weight <= 0) {
            throw new IllegalArgumentException("Phase weight must be positive.");
        }
        if (phaseName == null || phaseName.length() == 0) {
            throw new IllegalArgumentException("Phase name must be set.");
        }
        this.weight = weight;
        this.phaseName = phaseName;
        this.phaseId = phaseId;
    }

    public String toString() {
        return "Phase: " + this.phaseName + " - " + this.weight;
    }

    protected MultiStatus perform(EngineSession session, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus();
        this.perform(status, session, profile, deltas, monitor);
        if (status.matches(8)) {
            status.setMessage(Messages.Engine_Operation_Canceled_By_User);
        } else if (status.matches(4)) {
            status.setMessage(NLS.bind((String)Messages.Engine_Error_During_Phase, (Object)this.phaseName));
        }
        return status;
    }

    protected abstract void perform(MultiStatus var1, EngineSession var2, Profile var3, Operand[] var4, IProgressMonitor var5);
}

