/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.service.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.eclipse.virgo.teststubs.osgi.internal.Duplicator;
import org.eclipse.virgo.teststubs.osgi.service.cm.StubConfigurationAdmin;
import org.eclipse.virgo.teststubs.osgi.service.cm.aspects.DeletedConfiguration;
import org.osgi.service.cm.Configuration;

public final class StubConfiguration
implements Configuration {
    private final StubConfigurationAdmin configurationAdmin;
    private final String pid;
    private final String factoryPid;
    private volatile boolean deleted = false;
    private volatile Dictionary properties;
    private final Object propertiesMonitor = new Object();
    private volatile String bundleLocation;
    private final Object bundleLocationMonitor = new Object();

    public StubConfiguration(String pid) {
        this(pid, null);
    }

    public StubConfiguration(String pid, String factoryPid) {
        this.pid = pid;
        this.factoryPid = factoryPid;
        this.configurationAdmin = new StubConfigurationAdmin(pid == null ? factoryPid : pid, this);
    }

    StubConfiguration(StubConfigurationAdmin configurationAdmin, String pid, String factoryPid, String bundleLocation) {
        this.configurationAdmin = configurationAdmin;
        this.pid = pid;
        this.factoryPid = pid;
        this.bundleLocation = bundleLocation;
    }

    public void delete() throws IOException {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        this.configurationAdmin.deleteConfiguration(this.pid == null ? this.factoryPid : this.pid);
        this.deleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBundleLocation() {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        Object object = this.bundleLocationMonitor;
        synchronized (object) {
            return this.bundleLocation;
        }
    }

    public String getFactoryPid() {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        return this.factoryPid;
    }

    public String getPid() {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getProperties() {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        Object object = this.propertiesMonitor;
        synchronized (object) {
            return this.properties == null ? null : Duplicator.shallowCopy(this.properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubConfiguration addProperty(String key, Object value) {
        Object object = this.propertiesMonitor;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new Hashtable();
                this.updateSystemProperties(this.properties);
            }
            this.properties.put(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundleLocation(String bundleLocation) {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        Object object = this.bundleLocationMonitor;
        synchronized (object) {
            this.bundleLocation = bundleLocation;
        }
    }

    public void update() throws IOException {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Dictionary properties) throws IOException {
        DeletedConfiguration.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_service_cm_aspects_DeletedConfiguration$1$d62531ad(this);
        Assert.assertNotNull(properties, "properties");
        Object object = this.propertiesMonitor;
        synchronized (object) {
            Dictionary copy = Duplicator.shallowCopy(properties);
            this.updateSystemProperties(copy);
            this.properties = copy;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StubConfiguration other = (StubConfiguration)obj;
        return this.pid.equals(other.pid);
    }

    public int hashCode() {
        return this.pid.hashCode();
    }

    public String toString() {
        return String.format("pid: %s, factoryPid: %s, deleted: %b", this.pid, this.factoryPid, this.deleted);
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    private void updateSystemProperties(Dictionary properties) {
        properties.put("service.pid", this.pid);
        if (this.factoryPid == null) {
            properties.remove("service.factoryPid");
        } else {
            properties.put("service.factoryPid", this.factoryPid);
        }
    }
}

