/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.configure;

import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IConfigureOption;

public class StringConfigureOption
extends AbstractConfigurationOption {
    private String value;

    public StringConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = "";
    }

    public StringConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
        this.value = "";
    }

    private StringConfigureOption(String name, AutotoolsConfiguration cfg, String value) {
        super(name, cfg);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        if (!newValue.equals(this.value)) {
            this.cfg.setDirty(true);
            this.value = newValue;
        }
    }

    public boolean isParmSet() {
        return this.value.length() > 0;
    }

    public String getParameter() {
        if (this.isParmSet()) {
            return String.valueOf(this.getParameterName()) + "=" + this.getValue();
        }
        return "";
    }

    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new StringConfigureOption(this.name, config, this.value);
    }

    public int getType() {
        return 2;
    }
}

