/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.MakeUIImages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MessageLine {
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private boolean hasErrorMessage;
    private CLabel clabel;

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public MessageLine(Composite parent, int style) {
        this.clabel = new CLabel(parent, style);
        this.fNormalMsgAreaBackground = this.clabel.getBackground();
    }

    public void setErrorMessage(String message) {
        if (message != null && message.length() > 0) {
            this.hasErrorMessage = true;
            this.clabel.setText(message);
            this.clabel.setImage(MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ERROR));
            this.clabel.setBackground(JFaceColors.getErrorBackground((Display)this.clabel.getDisplay()));
            return;
        }
        this.hasErrorMessage = false;
        this.clabel.setText(this.fMessage);
        this.clabel.setImage(null);
        this.clabel.setBackground(this.fNormalMsgAreaBackground);
    }

    public void setMessage(String message) {
        this.fMessage = message;
        this.clabel.setText(message);
    }

    public boolean hasErrorMessage() {
        return this.hasErrorMessage;
    }
}

