/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.logging.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.logging.internal.LogEntry;

public class LogDaemon
extends TimerTask {
    private int logLevel;
    private BufferedWriter writer;
    private static final String[] NAMES = new String[]{"fatal", "critical", "info", "debug"};

    public LogDaemon(BufferedWriter writer, int level) {
        this.logLevel = level % NAMES.length;
        Timer t = new Timer("LogDaemon", true);
        t.scheduleAtFixedRate((TimerTask)this, 100L, 5000L);
    }

    public void run() {
        LinkedList<LogEntry> entries = LogManager.getInstance().getEntries();
        if (this.writer == null || entries.size() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        DateFormat df = DateFormat.getTimeInstance();
        while (!entries.isEmpty()) {
            LogEntry le = entries.removeFirst();
            if (le.level > this.logLevel) continue;
            try {
                builder.delete(0, builder.length());
                String time = df.format(new Date(System.currentTimeMillis()));
                builder.append("[" + NAMES[le.level] + "] - " + time + " - ");
                builder.append(String.valueOf(le.message) + "\n");
                this.writer.write(builder.toString());
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

