/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;

public class ExecutionOccurrence
extends BasicExecutionOccurrence
implements ITimeRange {
    protected int[] fillRGB;
    protected int[] strokeRGB;
    protected IImage image;
    protected IImage ellipsesImage;
    protected ITmfTimestamp startTime;
    protected ITmfTimestamp endTime;
    protected boolean hasTime;

    @Override
    public void setLifeline(Lifeline theLifeline) {
        super.setLifeline(theLifeline);
        if (this.lifeline != null && this.hasTime) {
            this.lifeline.hasTime = true;
            if (this.lifeline.getFrame() != null) {
                this.lifeline.getFrame().setHasTimeInfo(true);
            }
        }
    }

    public void setFillColor(int _r, int _g, int _b) {
        this.fillRGB = new int[3];
        this.fillRGB[0] = _r;
        this.fillRGB[1] = _g;
        this.fillRGB[2] = _b;
    }

    public void setStrokeColor(int _r, int _g, int _b) {
        this.strokeRGB = new int[3];
        this.strokeRGB[0] = _r;
        this.strokeRGB[1] = _g;
        this.strokeRGB[2] = _b;
    }

    public void setImage(IImage image_) {
        this.image = image_;
    }

    public void setTopEllipsesImage(IImage image_) {
        this.ellipsesImage = image_;
    }

    public void setStartTime(ITmfTimestamp time) {
        this.startTime = time.clone();
        this.hasTime = true;
        if (this.lifeline != null) {
            this.lifeline.setTimeInfo(true);
        }
    }

    public void setEndTime(ITmfTimestamp time) {
        this.endTime = time.clone();
        this.hasTime = true;
        if (this.lifeline != null) {
            this.lifeline.setTimeInfo(true);
        }
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.startTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    @Override
    public void draw(IGC context) {
        super.draw(context);
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.image != null) {
            context.drawImage(this.image, x + width - 4, y + height - 11, 8, 11);
        }
        if (this.ellipsesImage != null) {
            context.drawImage(this.ellipsesImage, x + width, y, 40, 10);
        }
    }

    @Override
    protected IColor setUnselectedFillColor(IGC context) {
        if (this.fillRGB != null) {
            IColor tempFillColor = context.createColor(this.fillRGB[0], this.fillRGB[1], this.fillRGB[2]);
            if (Frame.getUserPref().useGradienColor()) {
                context.setGradientColor(tempFillColor);
                context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_EXEC"));
                context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
            } else {
                context.setBackground(tempFillColor);
            }
            return tempFillColor;
        }
        return super.setUnselectedFillColor(context);
    }

    @Override
    protected IColor setUnselectedStrokeColor(IGC context) {
        if (this.strokeRGB != null) {
            IColor tempStrokeColor = context.createColor(this.strokeRGB[0], this.strokeRGB[1], this.strokeRGB[2]);
            context.setForeground(tempStrokeColor);
            return tempStrokeColor;
        }
        return super.setUnselectedStrokeColor(context);
    }
}

