/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.lttng.tracecontrol.model.ProviderResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.model.TraceAdapterFactory;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.osgi.framework.BundleContext;

public class LTTngUiPlugin
extends SystemBasePlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.lttng.ui";
    public static final String ICON_ID_PROVIDER = "ICON_ID_PROVIDER";
    public static final String ICON_ID_TARGET = "ICON_ID_TARGET";
    public static final String ICON_ID_TRACE = "ICON_ID_TRACE";
    public static final String ICON_ID_NEW_TRACE = "ICON_ID_NEW_TRACE";
    public static final String ICON_ID_CONFIG_MARKERS = "ICON_ID_CONFIG_MARKERS";
    public static final String ICON_ID_CONFIG_TRACE = "ICON_ID_CONFIG_TRACE";
    public static final String ICON_ID_CHECKED = "ICON_ID_CHECKED";
    public static final String ICON_ID_UNCHECKED = "ICON_ID_UNCHECKED";
    public static final String ICON_ID_IMPORT_TRACE = "ICON_ID_IMPORT_TRACE";
    public static final String ICON_ID_EDIT = "ICON_ID_EDIT";
    private static LTTngUiPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        TraceDebug.init();
        IAdapterManager manager = Platform.getAdapterManager();
        TraceAdapterFactory factory = new TraceAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, ProviderResource.class);
        manager.registerAdapters((IAdapterFactory)factory, TargetResource.class);
        manager.registerAdapters((IAdapterFactory)factory, TraceResource.class);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        TraceDebug.stop();
        plugin = null;
        super.stop(context);
    }

    public static LTTngUiPlugin getDefault() {
        return plugin;
    }

    public SystemMessage getMessage(Throwable x) {
        String msg = x.getMessage();
        if (msg == null) {
            msg = "";
        }
        if (x instanceof ExecutionException && ((ExecutionException)x).getCause() != null) {
            msg = String.valueOf(msg) + " (" + ((ExecutionException)x).getCause().getMessage() + ")";
        }
        if (x instanceof TimeoutException) {
            msg = String.valueOf(msg) + " (" + Messages.Ltt_TimeoutMsg + ")";
        }
        return new SimpleSystemMessage(PLUGIN_ID, 69, msg, x);
    }

    protected void initializeImageRegistry() {
        String path = LTTngUiPlugin.getIconPath();
        this.putImageInRegistry(ICON_ID_PROVIDER, String.valueOf(path) + "obj16/providers.gif");
        this.putImageInRegistry(ICON_ID_TARGET, String.valueOf(path) + "obj16/targets.gif");
        this.putImageInRegistry(ICON_ID_TRACE, String.valueOf(path) + "obj16/trace.gif");
        this.putImageInRegistry(ICON_ID_NEW_TRACE, String.valueOf(path) + "elcl16/new_trace.gif");
        this.putImageInRegistry(ICON_ID_CONFIG_MARKERS, String.valueOf(path) + "elcl16/configure_markers.gif");
        this.putImageInRegistry(ICON_ID_CONFIG_TRACE, String.valueOf(path) + "elcl16/configure_trace.gif");
        this.putImageInRegistry(ICON_ID_CHECKED, String.valueOf(path) + "elcl16/checked.gif");
        this.putImageInRegistry(ICON_ID_UNCHECKED, String.valueOf(path) + "elcl16/unchecked.gif");
        this.putImageInRegistry(ICON_ID_IMPORT_TRACE, String.valueOf(path) + "elcl16/import_trace.gif");
        this.putImageInRegistry(ICON_ID_EDIT, String.valueOf(path) + "elcl16/edit.gif");
    }
}

