/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.event;

import java.util.HashMap;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventField;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventType;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;

public class LttngEventContent
extends TmfEventField {
    private LttngEvent fParentEvent;
    private HashMap<String, LttngEventField> fFieldsMap = new HashMap();

    public LttngEventContent() {
        super(":root:", null);
    }

    public LttngEventContent(LttngEvent thisParent) {
        super(":root:", null);
        this.fParentEvent = thisParent;
    }

    public LttngEventContent(LttngEvent thisParent, HashMap<String, LttngEventField> thisContent) {
        super(":root:", null);
        this.fParentEvent = thisParent;
        this.fFieldsMap = thisContent;
    }

    public LttngEventContent(LttngEventContent oldContent) {
        this(oldContent.getEvent(), oldContent.getMapContent());
    }

    public synchronized LttngEvent getEvent() {
        return this.fParentEvent;
    }

    public synchronized void setEvent(LttngEvent newParent) {
        this.fParentEvent = newParent;
    }

    public void emptyContent() {
        this.fFieldsMap.clear();
    }

    public Object[] getRawContent() {
        Object[] returnedContent = this.fFieldsMap.values().toArray(new Object[this.fFieldsMap.size()]);
        return returnedContent;
    }

    public HashMap<String, LttngEventField> getMapContent() {
        return this.fFieldsMap;
    }

    public synchronized LttngEventField[] getFields() {
        int nbFields = this.fParentEvent.getType().getFieldNames().length;
        if (this.fFieldsMap.size() < nbFields) {
            LttngEventField tmpField = null;
            LttngEventType tmpType = this.fParentEvent.getType();
            int pos = 0;
            while (pos < nbFields) {
                String name = null;
                LttngEvent lttngTmpEvent = this.getEvent();
                JniEvent tmpEvent = lttngTmpEvent.convertEventTmfToJni();
                if (tmpEvent != null) {
                    name = tmpType.getFieldName(pos);
                    Object newValue = tmpEvent.parseFieldByName(name);
                    tmpField = new LttngEventField(name, newValue, null);
                    this.fFieldsMap.put(name, tmpField);
                }
                ++pos;
            }
        }
        return this.fFieldsMap.values().toArray(new LttngEventField[this.fFieldsMap.size()]);
    }

    public synchronized LttngEventField getField(int position) {
        LttngEventField returnedField = null;
        String label = null;
        label = this.fParentEvent.getType().getFieldName(position);
        returnedField = this.getField(label);
        return returnedField;
    }

    public synchronized LttngEventField getField(String name) {
        Object newValue;
        JniEvent tmpEvent;
        if (name.equals("Content") || name.equals(":content:")) {
            return new LttngEventField(this.toString());
        }
        if (name.equals("Marker") || name.equals(":type:")) {
            return new LttngEventField(this.fParentEvent.getType().getName());
        }
        if (name.equals("Trace") || name.equals(":reference:")) {
            return new LttngEventField(this.fParentEvent.getReference());
        }
        if (name.equals("Timestamp") || name.equals(":timestamp:")) {
            return new LttngEventField(this.fParentEvent.getTimestamp().toString());
        }
        if (name.equals(":source:")) {
            return new LttngEventField(this.fParentEvent.getSource());
        }
        LttngEventField returnedField = this.fFieldsMap.get(name);
        if (returnedField == null && (tmpEvent = this.getEvent().convertEventTmfToJni()) != null && (newValue = tmpEvent.parseFieldByName(name)) != null) {
            returnedField = new LttngEventField(name, newValue);
            this.fFieldsMap.put(name, returnedField);
        }
        return returnedField;
    }

    public String toString() {
        LttngEventField[] allFields = this.getFields();
        StringBuffer strBuffer = new StringBuffer();
        int pos = 0;
        while (pos < allFields.length) {
            if (pos != 0) {
                strBuffer.append(",");
            }
            strBuffer.append(allFields[pos].toString());
            ++pos;
        }
        return strBuffer.toString();
    }

    public LttngEventContent clone() {
        LttngEventContent clone = (LttngEventContent)super.clone();
        LttngEventField[] fields = this.getFields();
        LttngEventField[] subfields = new LttngEventField[fields.length];
        int i = 0;
        while (i < fields.length) {
            subfields[i] = fields[i].clone();
            ++i;
        }
        clone.setValue(this.getValue(), (ITmfEventField[])subfields);
        clone.fFieldsMap = new HashMap();
        for (String key : this.fFieldsMap.keySet()) {
            clone.fFieldsMap.put(key, this.fFieldsMap.get(key).clone());
        }
        return clone;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fFieldsMap == null ? 0 : this.fFieldsMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LttngEventContent)) {
            return false;
        }
        LttngEventContent other = (LttngEventContent)((Object)obj);
        return !(this.fFieldsMap == null ? other.fFieldsMap != null : !this.fFieldsMap.equals(other.fFieldsMap));
    }
}

