/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings.capabilities;

import org.eclipse.lemminx.settings.capabilities.ClientCapabilitiesWrapper;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;

public class ServerCapabilitiesInitializer {
    private ServerCapabilitiesInitializer() {
    }

    public static ServerCapabilities getNonDynamicServerCapabilities(ClientCapabilitiesWrapper clientCapabilities, boolean isIncremental) {
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setTextDocumentSync(isIncremental ? TextDocumentSyncKind.Incremental : TextDocumentSyncKind.Full);
        serverCapabilities.setDocumentSymbolProvider(!clientCapabilities.isDocumentSymbolDynamicRegistrationSupported());
        serverCapabilities.setDocumentHighlightProvider(!clientCapabilities.isDocumentHighlightDynamicRegistered());
        serverCapabilities.setDocumentFormattingProvider(!clientCapabilities.isFormattingDynamicRegistrationSupported());
        serverCapabilities.setDocumentRangeFormattingProvider(!clientCapabilities.isRangeFormattingDynamicRegistrationSupported());
        serverCapabilities.setHoverProvider(!clientCapabilities.isHoverDynamicRegistered());
        serverCapabilities.setFoldingRangeProvider(!clientCapabilities.isRangeFoldingDynamicRegistrationSupported());
        serverCapabilities.setDefinitionProvider(!clientCapabilities.isDefinitionDynamicRegistered());
        serverCapabilities.setTypeDefinitionProvider(!clientCapabilities.isTypeDefinitionDynamicRegistered());
        serverCapabilities.setReferencesProvider(!clientCapabilities.isReferencesDynamicRegistrationSupported());
        serverCapabilities.setLinkedEditingRangeProvider(!clientCapabilities.isLinkedEditingRangeDynamicRegistered());
        serverCapabilities.setColorProvider(!clientCapabilities.isColorDynamicRegistrationSupported());
        serverCapabilities.setSelectionRangeProvider(!clientCapabilities.isSelectionRangeDynamicRegistered());
        if (clientCapabilities.isWorkspaceFoldersSupported()) {
            WorkspaceFoldersOptions workspaceFolders = new WorkspaceFoldersOptions();
            workspaceFolders.setSupported(true);
            workspaceFolders.setChangeNotifications(true);
            serverCapabilities.setWorkspace(new WorkspaceServerCapabilities(workspaceFolders));
        }
        if (!clientCapabilities.isLinkDynamicRegistrationSupported()) {
            serverCapabilities.setDocumentLinkProvider(ServerCapabilitiesConstants.DEFAULT_LINK_OPTIONS);
        }
        if (!clientCapabilities.isCompletionDynamicRegistrationSupported()) {
            serverCapabilities.setCompletionProvider(ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (!clientCapabilities.isCodeLensDynamicRegistrationSupported()) {
            serverCapabilities.setCodeLensProvider(ServerCapabilitiesConstants.DEFAULT_CODELENS_OPTIONS);
        }
        if (!clientCapabilities.isCodeActionDynamicRegistered()) {
            serverCapabilities.setCodeActionProvider(ServerCapabilitiesConstants.DEFAULT_CODEACTION_OPTIONS);
        }
        if (!clientCapabilities.isRenameDynamicRegistrationSupported()) {
            serverCapabilities.setRenameProvider(ServerCapabilitiesConstants.DEFAULT_RENAME_OPTIONS);
        }
        return serverCapabilities;
    }
}

