/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesTraversalOperation
extends AbstractWorkingCopyOperation
implements IActionOperationProcessor {
    protected IResourceChangeVisitor visitor;
    protected int depth;

    public ResourcesTraversalOperation(String operationName, Class<? extends NLS> messagesClass, IResource[] resources, IResourceChangeVisitor visitor, int depth) {
        super(operationName, messagesClass, resources);
        this.visitor = visitor;
        this.depth = depth;
    }

    public ResourcesTraversalOperation(String operationName, Class<? extends NLS> messagesClass, IResourceProvider provider, IResourceChangeVisitor visitor, int depth) {
        super(operationName, messagesClass, provider);
        this.visitor = visitor;
        this.depth = depth;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        resources = this.depth == 0 ? resources : FileUtility.shrinkChildNodes(resources);
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ResourceChange change = ResourceChange.wrapLocalResource(null, SVNRemoteStorage.instance().asLocalResourceAccessible(current), false);
                    if (change != null) {
                        change.traverse(ResourcesTraversalOperation.this.visitor, ResourcesTraversalOperation.this.depth, ResourcesTraversalOperation.this, monitor);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    @Override
    public void doOperation(IActionOperation op, IProgressMonitor monitor) {
        this.reportStatus(op.run(monitor).getStatus());
    }
}

