/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreateFolderOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String[] names;
    protected String comment;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFolderOperation(IRepositoryResource parent, String name, String comment) {
        this(parent, new String[]{name}, comment);
    }

    public CreateFolderOperation(IRepositoryResource parent, String[] names, String comment) {
        super("Operation_CreateFolder", SVNMessages.class, new IRepositoryResource[]{parent});
        this.names = names;
        this.comment = comment;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        IRepositoryResource parent = this.operableData()[0];
        IRepositoryLocation location = parent.getRepositoryLocation();
        ProgressMonitorUtility.setTaskInfo(monitor, this, String.valueOf(parent.getUrl()) + "/" + this.names[0]);
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        int i = 0;
        while (i < this.names.length) {
            fullSet.addAll(Arrays.asList(SVNUtility.makeResourceSet(parent, this.names[i], false)));
            ++i;
        }
        IRepositoryResource[] toBeCreated = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        Object[] childUrls = SVNUtility.asURLArray(toBeCreated, true);
        Arrays.sort(childUrls);
        ISVNNotificationCallback notify = new ISVNNotificationCallback((String[])childUrls, location){
            private final /* synthetic */ String[] val$childUrls;
            private final /* synthetic */ IRepositoryLocation val$location;
            {
                this.val$childUrls = stringArray;
                this.val$location = iRepositoryLocation;
            }

            public void notify(SVNNotification info) {
                String[] path = this.val$childUrls;
                CreateFolderOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, this.val$location);
                String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                CreateFolderOperation.this.writeToConsole(1, message);
            }
        };
        this.complexWriteToConsole(new Runnable((String[])childUrls, monitor, location){
            private final /* synthetic */ String[] val$childUrls;
            private final /* synthetic */ IProgressMonitor val$monitor;
            private final /* synthetic */ IRepositoryLocation val$location;
            {
                this.val$childUrls = stringArray;
                this.val$monitor = iProgressMonitor;
                this.val$location = iRepositoryLocation;
            }

            public void run() {
                CreateFolderOperation.this.writeToConsole(0, "svn mkdir");
                int i = 0;
                while (i < this.val$childUrls.length && !this.val$monitor.isCanceled()) {
                    CreateFolderOperation.this.writeToConsole(0, " \"" + SVNUtility.decodeURL(this.val$childUrls[i]) + "\"");
                    ++i;
                }
                CreateFolderOperation.this.writeToConsole(0, " -m \"" + CreateFolderOperation.this.comment + "\"" + FileUtility.getUsernameParam(this.val$location.getUsername()) + "\n");
            }
        });
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            proxy.mkdir((String[])childUrls, this.comment, 0L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            parent.getRepositoryLocation().releaseSVNProxy(proxy);
        }
        ProgressMonitorUtility.progress(monitor, 1, 1);
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.name});
    }
}

