/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IChangeStateProvider;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRemoteStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.AbstractSVNStorage;
import org.eclipse.team.svn.core.svnstorage.SVNFileChange;
import org.eclipse.team.svn.core.svnstorage.SVNFolderChange;
import org.eclipse.team.svn.core.svnstorage.SVNLocalFile;
import org.eclipse.team.svn.core.svnstorage.SVNLocalFolder;
import org.eclipse.team.svn.core.svnstorage.SVNLocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocationWrapper;
import org.eclipse.team.svn.core.utility.AsynchronousActiveQueue;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.IQueuedElement;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRemoteStorage
extends AbstractSVNStorage
implements IRemoteStorage {
    public static final String PREF_REPOSITORIES_NODE = "repositories";
    public static final String PREF_MIGRATE_FROM_AUTH_DB_NODE = "migrateFromAuthorizationDatabase";
    public static final String STATE_INFO_FILE_NAME = ".svnRepositories";
    private static SVNRemoteStorage instance = new SVNRemoteStorage();
    protected Map localResources = new HashMap(500);
    protected Map switchedToUrls = Collections.synchronizedMap(new LinkedHashMap());
    protected Map externalsLocations = new HashMap();
    protected Map<Class, List<IResourceStatesListener>> resourceStateListeners = new HashMap<Class, List<IResourceStatesListener>>();
    protected AsynchronousActiveQueue<SvnChange> fetchQueue = new AsynchronousActiveQueue<SvnChange>("Operation_UpdateSVNCache", new AsynchronousActiveQueue.IRecordHandler<SvnChange>(){

        @Override
        public void process(IProgressMonitor monitor, IActionOperation op, SvnChange record) {
            SVNChangeStatus[] st = record.st;
            IResource target = record.target;
            IProject prj = target.getProject();
            IPath location = prj.getLocation();
            if (location != null) {
                int projectEnd = location.toString().length();
                int i = 0;
                while (i < st.length && !monitor.isCanceled()) {
                    ProgressMonitorUtility.progress(monitor, i, -1);
                    if (st[i] != null && st[i].nodeKind == SVNEntry.Kind.DIR && st[i].path.length() > projectEnd) {
                        IFolder folder = prj.getFolder((IPath)new Path(st[i].path.substring(projectEnd)));
                        ProgressMonitorUtility.setTaskInfo(monitor, op, folder.getFullPath().toString());
                        ILocalFolder local = (ILocalFolder)SVNRemoteStorage.this.asLocalResource((IResource)folder);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            local.getChildren();
                        }
                    }
                    ++i;
                }
            }
        }
    }, false);
    protected AsynchronousActiveQueue<ResourceStatesChangedEvent> eventQueue = new AsynchronousActiveQueue<ResourceStatesChangedEvent>("Operation_UpdateSVNCache", new AsynchronousActiveQueue.IRecordHandler<ResourceStatesChangedEvent>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(IProgressMonitor monitor, IActionOperation op, ResourceStatesChangedEvent event) {
            IResourceStatesListener[] listeners;
            Map<Class, List<IResourceStatesListener>> map = SVNRemoteStorage.this.resourceStateListeners;
            synchronized (map) {
                List<IResourceStatesListener> listenersList = SVNRemoteStorage.this.resourceStateListeners.get(event.getClass());
                if (listenersList == null || listenersList.size() == 0) {
                    return;
                }
                listeners = listenersList.toArray(new IResourceStatesListener[listenersList.size()]);
            }
            int i = 0;
            while (i < listeners.length && !monitor.isCanceled()) {
                listeners[i].resourcesStateChanged(event);
                ++i;
            }
        }
    }, true);
    protected long lastMonitorTime = System.currentTimeMillis();
    protected Map<IResource, File> changeMonitorMap = new HashMap<IResource, File>();
    protected int suggestedLoadDepth = 2;
    private static final IStateFilter SF_NONSVN = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state == "Prereplaced" || state == "New" || state == "Ignored" || state == IStateFilter.ST_NOTEXISTS || state == "Linked" || state == "Obstructed";
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public void resetExternalChangesMonitor() {
        this.lastMonitorTime = System.currentTimeMillis();
    }

    public void checkForExternalChanges() {
        long lastMonitorTime = this.lastMonitorTime;
        ArrayList<IResource> changed = new ArrayList<IResource>();
        Object[] objectArray = this.changeMonitorMap.entrySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Map.Entry entry = (Map.Entry)item;
            if (((File)entry.getValue()).lastModified() > lastMonitorTime) {
                changed.add((IResource)entry.getKey());
            }
            ++n2;
        }
        if (changed.size() > 0) {
            IResource[] resources = changed.toArray(new IResource[changed.size()]);
            SVNRemoteStorage.instance().refreshLocalResources(resources, 2);
            this.fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(resources, 2, 0));
        }
        this.resetExternalChangesMonitor();
    }

    public static SVNRemoteStorage instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map<Class, List<IResourceStatesListener>> map = this.resourceStateListeners;
        synchronized (map) {
            List<IResourceStatesListener> listenersList = this.resourceStateListeners.get(eventClass);
            if (listenersList == null) {
                listenersList = new ArrayList<IResourceStatesListener>();
                this.resourceStateListeners.put(eventClass, listenersList);
            }
            if (!listenersList.contains(listener)) {
                listenersList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map<Class, List<IResourceStatesListener>> map = this.resourceStateListeners;
        synchronized (map) {
            List<IResourceStatesListener> listenersList = this.resourceStateListeners.get(eventClass);
            if (listenersList != null) {
                listenersList.remove(listener);
                if (listenersList.size() == 0) {
                    this.resourceStateListeners.remove(eventClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireResourceStatesChangedEvent(ResourceStatesChangedEvent event) {
        if (event.getSize() == 0) {
            return;
        }
        Map<Class, List<IResourceStatesListener>> map = this.resourceStateListeners;
        synchronized (map) {
            List<IResourceStatesListener> listeners = this.resourceStateListeners.get(event.getClass());
            if (listeners == null || listeners.isEmpty()) {
                return;
            }
        }
        this.eventQueue.push(event);
    }

    @Override
    public void initialize(Map<String, Object> preferences) throws Exception {
        preferences.put("internal.stateInfoFile", STATE_INFO_FILE_NAME);
        preferences.put("internal.repoNodeName", PREF_REPOSITORIES_NODE);
        preferences.put("internal.authNodeName", PREF_MIGRATE_FROM_AUTH_DB_NODE);
        super.initialize(preferences);
    }

    @Override
    public IResourceChange asResourceChange(IChangeStateProvider changeState, boolean update) {
        int changeMask;
        IResource resource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path location = new Path(changeState.getLocalPath());
        SVNEntry.Kind nodeKind = changeState.getNodeKind();
        SVNEntryStatus.Kind propKind = changeState.getPropertiesChangeType();
        SVNEntryStatus.Kind textKind = changeState.getTextChangeType();
        boolean isCopied = changeState.isCopied();
        boolean isSwitched = changeState.isSwitched();
        SVNRevision.Number remoteRevision = changeState.getChangeRevision();
        long revision = remoteRevision != null ? remoteRevision.getNumber() : -1L;
        SVNConflictDescriptor treeConflictDescriptor = changeState.getTreeConflictDescriptor();
        String textStatusStr = SVNRemoteStorage.getTextStatusString(propKind, textKind, update);
        String propStatusStr = SVNRemoteStorage.getPropStatusString(propKind);
        if (nodeKind == SVNEntry.Kind.DIR) {
            int changeMask2;
            resource = changeState.getExact((IResource[])root.findContainersForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute())));
            if (resource == null) {
                return null;
            }
            if (!resource.getName().equals(location.lastSegment())) {
                resource = root.getContainerForLocation((IPath)location);
            }
            if (IStateFilter.SF_NOTEXISTS.accept(resource, textStatusStr, changeMask2 = SVNRemoteStorage.getChangeMask(textKind, propKind, isCopied, isSwitched, false))) {
                revision = -1L;
            }
            return new SVNFolderChange(resource, revision, textStatusStr, propStatusStr, changeMask2, changeState.getChangeAuthor(), changeState.getChangeDate(), treeConflictDescriptor, null, changeState.getComment());
        }
        resource = changeState.getExact((IResource[])root.findFilesForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute())));
        if (resource == null) {
            return null;
        }
        if (!resource.getName().equals(location.lastSegment())) {
            resource = root.getFileForLocation((IPath)location);
        }
        if (IStateFilter.SF_NOTEXISTS.accept(resource, textStatusStr, changeMask = SVNRemoteStorage.getChangeMask(textKind, propKind, isCopied, isSwitched, false))) {
            revision = -1L;
        }
        return new SVNFileChange(resource, revision, textStatusStr, propStatusStr, changeMask, changeState.getChangeAuthor(), changeState.getChangeDate(), treeConflictDescriptor, null, changeState.getComment());
    }

    @Override
    public byte[] resourceChangeAsBytes(IResourceChange resource) {
        if (resource == null) {
            return null;
        }
        int kind = resource.getPegRevision().getKind().id;
        String originatorData = null;
        if (resource.getOriginator() != null) {
            byte[] data = this.repositoryResourceAsBytes(resource.getOriginator());
            originatorData = new String(Base64.encode((byte[])data));
        }
        long lastCommitDate = resource.getLastCommitDate();
        String comment = resource.getComment();
        String retVal = String.valueOf(String.valueOf(resource instanceof ILocalFolder)) + ";" + new String(Base64.encode((byte[])FileUtility.getWorkingCopyPath(resource.getResource()).getBytes())) + ";" + resource.getRevision() + ";" + resource.getTextStatus() + ";" + resource.getAuthor() + ";" + (lastCommitDate == 0L ? "null" : String.valueOf(lastCommitDate)) + ";" + String.valueOf(kind) + ";" + (kind == SVNRevision.Kind.NUMBER.id ? String.valueOf(((SVNRevision.Number)resource.getPegRevision()).getNumber()) : String.valueOf(kind)) + ";" + (originatorData != null ? originatorData : "null") + ";" + (comment == null ? "null" : new String(Base64.encode((byte[])comment.getBytes()))) + ";" + resource.getChangeMask() + ";" + this.getTreeConflictDescriptorAsString(resource.getTreeConflictDescriptor()) + ";" + resource.getPropStatus();
        return retVal.getBytes();
    }

    protected String getTreeConflictDescriptorAsString(SVNConflictDescriptor conflictDescriptor) {
        String retVal = String.valueOf(conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.action.id)) + ";" + (conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.reason.id)) + ";" + (conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.operation.id)) + ";" + this.getSVNConflictVersionAsString(conflictDescriptor == null ? null : conflictDescriptor.srcLeftVersion) + ";" + this.getSVNConflictVersionAsString(conflictDescriptor == null ? null : conflictDescriptor.srcRightVersion);
        return retVal;
    }

    protected String getSVNConflictVersionAsString(SVNConflictVersion conflictVersion) {
        String retVal = String.valueOf(conflictVersion == null ? "null" : String.valueOf(conflictVersion.nodeKind.id)) + ";" + (conflictVersion == null ? "null" : new String(Base64.encode((byte[])conflictVersion.pathInRepos.getBytes()))) + ";" + (conflictVersion == null ? "null" : String.valueOf(conflictVersion.pegRevision)) + ";" + (conflictVersion == null ? "null" : new String(Base64.encode((byte[])conflictVersion.reposURL.getBytes())));
        return retVal;
    }

    @Override
    public IResourceChange resourceChangeFromBytes(byte[] bytes) {
        SVNLocalResource change;
        long pegNum;
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = "true".equals(data[0]);
        String name = new String(Base64.decode((byte[])data[1].getBytes()));
        long revision = Long.parseLong(data[2]);
        String textStatus = this.deserializeStatus(data[3]);
        String author = "null".equals(data[4]) ? null : data[4];
        long lastCommitDate = "null".equals(data[5]) ? 0L : Long.parseLong(data[5]);
        int revisionKind = Integer.parseInt(data[6]);
        SVNRevision pegRevision = null;
        pegRevision = revisionKind == SVNRevision.Kind.NUMBER.id ? ((pegNum = Long.parseLong(data[7])) == revision || revision == -1L ? null : SVNRevision.fromNumber(pegNum)) : SVNRevision.fromKind(SVNRevision.Kind.fromId(revisionKind));
        String comment = "null".equals(data[9]) ? null : new String(Base64.decode((byte[])data[9].getBytes()));
        int changeMask = "null".equals(data[10]) ? 0 : Integer.parseInt(data[10]);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String propStatus = "Normal";
        if (data.length >= 23) {
            propStatus = this.deserializeStatus(data[22]);
        } else if ((changeMask & 2) != 0) {
            propStatus = "Modified";
            if ((changeMask & 1) == 0) {
                textStatus = "Normal";
            }
        }
        SVNConflictDescriptor treeConflict = this.getTreeConflictDescriptorFromString(name, data);
        SVNLocalResource sVNLocalResource = change = isFolder ? new SVNFolderChange((IResource)root.getContainerForLocation((IPath)new Path(name)), revision, textStatus, propStatus, changeMask, author, lastCommitDate, treeConflict, pegRevision, comment) : new SVNFileChange((IResource)root.getFileForLocation((IPath)new Path(name)), revision, textStatus, propStatus, changeMask, author, lastCommitDate, treeConflict, pegRevision, comment);
        if (!"null".equals(data[8])) {
            byte[] originatorData = Base64.decode((byte[])data[8].getBytes());
            change.setOriginator(this.repositoryResourceFromBytes(originatorData));
        }
        return change;
    }

    protected SVNConflictDescriptor getTreeConflictDescriptorFromString(String path, String[] data) {
        SVNConflictDescriptor conflictDescriptor = null;
        if (data.length >= 23 && !"null".equals(data[11])) {
            SVNConflictDescriptor.Action action = "null".equals(data[11]) ? SVNConflictDescriptor.Action.MODIFY : SVNConflictDescriptor.Action.fromId(Integer.parseInt(data[11]));
            SVNConflictDescriptor.Reason reason = "null".equals(data[12]) ? SVNConflictDescriptor.Reason.MODIFIED : SVNConflictDescriptor.Reason.fromId(Integer.parseInt(data[12]));
            SVNConflictDescriptor.Operation operation = "null".equals(data[13]) ? SVNConflictDescriptor.Operation.NONE : SVNConflictDescriptor.Operation.fromId(Integer.parseInt(data[13]));
            conflictDescriptor = new SVNConflictDescriptor(path, action, reason, operation, this.getSVNConflictVersionFromString(data, true), this.getSVNConflictVersionFromString(data, false));
        }
        return conflictDescriptor;
    }

    protected SVNConflictVersion getSVNConflictVersionFromString(String[] data, boolean isLeft) {
        int indexShift = isLeft ? 0 : 4;
        SVNEntry.Kind nodeKind = SVNEntry.Kind.fromId("null".equals(data[14 + indexShift]) ? 0 : Integer.parseInt(data[14 + indexShift]));
        String pathInRepos = "null".equals(data[15 + indexShift]) ? null : new String(Base64.decode((byte[])data[15 + indexShift].getBytes()));
        long pegRevision = "null".equals(data[16 + indexShift]) ? 0L : Long.parseLong(data[16 + indexShift]);
        String reposUrl = "null".equals(data[17 + indexShift]) ? null : new String(Base64.decode((byte[])data[17 + indexShift].getBytes()));
        return new SVNConflictVersion(reposUrl, pegRevision, pathInRepos, nodeKind);
    }

    public synchronized IResource[] getRegisteredChildren(IContainer container) throws Exception {
        if (container == null || container.getProject() == null) {
            return null;
        }
        IResource[] members = FileUtility.resourceMembers(container, false);
        Map map = (Map)this.localResources.get(container);
        if (map == null) {
            this.loadLocalResourcesSubTree((IResource)container, 1);
            map = (Map)this.localResources.get(container);
        }
        HashSet<IResource> retVal = null;
        if (map != null) {
            retVal = new HashSet<IResource>(Arrays.asList(members));
            for (Object local : map.values()) {
                if (((ILocalResource)local).getStatus() == IStateFilter.ST_NOTEXISTS) continue;
                retVal.add(((ILocalResource)local).getResource());
            }
        }
        return retVal == null ? members : retVal.toArray(new IResource[retVal.size()]);
    }

    @Override
    public ILocalResource asLocalResourceDirty(IResource resource) {
        if (!CoreExtensionsManager.instance().getOptionProvider().is("svnCacheEnabled")) {
            return this.asLocalResource(resource);
        }
        if (resource == null || resource.getProject() == null || !resource.getProject().isAccessible()) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        ILocalResource retVal = this.getCachedResource(resource);
        if (retVal == null) {
            ILocalResource parent = this.getFirstExistingParentLocal(resource);
            int mask = parent == null ? 0 : parent.getChangeMask() & 8;
            retVal = this.wrapUnexistingResource(resource, IStateFilter.ST_NOTEXISTS, mask);
        }
        return retVal;
    }

    protected ILocalResource getCachedResource(IResource resource) {
        Map map = (Map)this.localResources.get(resource.getParent());
        if (map != null) {
            return (ILocalResource)map.get(resource);
        }
        return null;
    }

    protected void setCachedResource(ILocalResource local) {
        IContainer parent = local.getResource().getParent();
        HashMap<IResource, ILocalResource> map = (HashMap<IResource, ILocalResource>)this.localResources.get(parent);
        if (map == null) {
            map = new HashMap<IResource, ILocalResource>();
            this.localResources.put(parent, map);
        }
        map.put(local.getResource(), local);
    }

    @Override
    public ILocalResource asLocalResourceAccessible(IResource resource) {
        ILocalResource retVal = this.asLocalResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(retVal)) {
            throw new UnreportableException(SVNMessages.formatErrorString("Error_InaccessibleResource", new String[]{resource == null ? "" : FileUtility.getWorkingCopyPath(resource)}));
        }
        return retVal;
    }

    @Override
    public ILocalResource asLocalResource(IResource resource) {
        return this.asLocalResourceImpl(resource, this.suggestedLoadDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILocalResource asLocalResourceImpl(IResource resource, int depth) {
        if (resource == null || resource.getProject() == null || !resource.getProject().isAccessible()) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        SVNRemoteStorage sVNRemoteStorage = this;
        synchronized (sVNRemoteStorage) {
            ILocalResource local = this.getCachedResource(resource);
            if (local == null) {
                try {
                    local = this.loadLocalResourcesSubTree(resource, depth);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (SVNConnectorException sVNConnectorException) {
                    return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return local;
        }
    }

    @Override
    public synchronized void refreshLocalResources(IResource[] resources, int depth) {
        this.suggestedLoadDepth = 1;
        if (depth == 2) {
            resources = FileUtility.shrinkChildNodes(resources);
            this.suggestedLoadDepth = 2;
        }
        int i = 0;
        while (i < resources.length) {
            this.refreshLocalResourceImpl(resources[i], depth);
            this.localResources.remove(resources[i].getParent());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalResource asLocalResource(IProject project, String url, int kind) {
        Map map = this.switchedToUrls;
        synchronized (map) {
            for (Map.Entry entry : this.switchedToUrls.entrySet()) {
                String cachedUrl = (String)entry.getValue();
                if (!SVNUtility.createPathForSVNUrl(cachedUrl).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) continue;
                IPath target = ((IPath)entry.getKey()).append(url.substring(cachedUrl.length())).removeFirstSegments(1);
                return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(target) : project.getFile(target)));
            }
        }
        String projectUrl = this.asRepositoryResource((IResource)project).getUrl();
        if (url.length() < projectUrl.length()) {
            return this.wrapUnexistingResource(null, "InternalInvalid", 0);
        }
        String pathInProject = url.substring(projectUrl.length());
        if (pathInProject.length() == 0) {
            return this.asLocalResource((IResource)project);
        }
        return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(pathInProject) : project.getFile(pathInProject)));
    }

    @Override
    public IRepositoryResource asRepositoryResource(IResource resource) {
        IPath parentPath;
        ILocalResource parent;
        IProject project = resource.getProject();
        IRepositoryResource baseResource = this.getConnectedProjectInformation(project).getRepositoryResource();
        if (resource.equals((Object)project)) {
            return SVNUtility.copyOf(baseResource);
        }
        IRepositoryLocation location = baseResource.getRepositoryLocation();
        String url = (String)this.switchedToUrls.get(resource.getFullPath());
        if (url == null && (parent = this.getFirstExistingParentLocal(resource)) != null && (parent.getChangeMask() & 8) != 0 && this.switchedToUrls.containsKey(parentPath = parent.getResource().getFullPath())) {
            url = String.valueOf((String)this.switchedToUrls.get(parentPath)) + "/" + resource.getFullPath().removeFirstSegments(parentPath.segmentCount()).toString();
        }
        if (url == null) {
            url = this.makeUrl(resource, baseResource);
        } else if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            location = this.wrapLocationIfRequired(location, url, resource.getType() == 1);
        }
        return resource instanceof IContainer ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    public IRepositoryResource asRepositoryResource(IRepositoryLocation location, SVNEntryRevisionReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        IRepositoryResource res = null;
        String url = reference.path;
        reference = new SVNEntryRevisionReference(SVNUtility.encodeURL(url), reference.pegRevision == null ? SVNRevision.HEAD : reference.pegRevision, reference.revision == null ? SVNRevision.HEAD : reference.revision);
        if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            boolean isFile = false;
            location = this.wrapLocationIfRequired(location, url, isFile);
        }
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNEntryInfo[] entriesInfo = SVNUtility.info(proxy, reference, SVNDepth.EMPTY, monitor);
            if (entriesInfo.length > 0) {
                SVNEntryInfo info = entriesInfo[0];
                if (info.kind == SVNEntry.Kind.FILE) {
                    res = location.asRepositoryFile(url, false);
                } else if (info.kind == SVNEntry.Kind.DIR) {
                    res = location.asRepositoryContainer(url, false);
                }
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        return res;
    }

    @Override
    public IRepositoryResource asRepositoryResource(IRepositoryLocation location, String url, boolean isFile) {
        String rootURL = location.getRepositoryRootUrl();
        if (rootURL == null) {
            rootURL = location.getUrl();
        }
        if (rootURL == null || !SVNUtility.createPathForSVNUrl(rootURL).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            location = this.wrapLocationIfRequired(location, url, isFile);
        }
        return !isFile ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    @Override
    public IRepositoryLocation getRepositoryLocation(IResource resource) {
        return this.getConnectedProjectInformation(resource.getProject()).getRepositoryLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation location, String url, boolean isFile) {
        if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            Map map = this.externalsLocations;
            synchronized (map) {
                ArrayList<IRepositoryLocation> locations = (ArrayList<IRepositoryLocation>)this.externalsLocations.get(location);
                if (locations == null) {
                    locations = new ArrayList<IRepositoryLocation>();
                    this.externalsLocations.put(location, locations);
                }
                boolean found = false;
                for (IRepositoryLocation tmp : locations) {
                    if (!url.startsWith(tmp.getUrl()) && !tmp.getUrl().startsWith(url)) continue;
                    location = tmp;
                    found = true;
                    break;
                }
                if (!found) {
                    location = new SVNRepositoryLocationWrapper(location, isFile ? url.substring(0, url.lastIndexOf(47)) : url);
                    locations.add(location);
                }
            }
        }
        return location;
    }

    protected ILocalResource wrapUnexistingResource(IResource resource, String state, int mask) {
        return resource == null || resource.getType() == 1 ? new SVNLocalFile(resource, -1L, -1L, state, "Normal", mask, null, 0L, null) : new SVNLocalFolder(resource, -1L, -1L, state, "Normal", mask, null, 0L, null);
    }

    protected String makeUrl(IResource resource, IRepositoryResource baseResource) {
        if (resource.getType() == 4) {
            return baseResource.getUrl();
        }
        IProject project = resource.getProject();
        String url = resource.getFullPath().toString();
        return String.valueOf(baseResource.getUrl()) + "/" + url.substring(project.getFullPath().toString().length() + 1);
    }

    protected SVNTeamProvider getConnectedProjectInformation(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider == null) {
            String errMessage = SVNMessages.formatErrorString("Error_NotConnectedProject", new String[]{project.getName()});
            throw new UnreportableException(errMessage);
        }
        if (!(provider instanceof SVNTeamProvider)) {
            String errMessage = SVNMessages.formatErrorString("Error_AnotherProvider", new String[]{project.getName(), provider.getID()});
            throw new UnreportableException(errMessage);
        }
        return (SVNTeamProvider)provider;
    }

    protected void refreshLocalResourceImpl(IResource resource, int depth) {
        if (resource.getType() != 1) {
            Map map;
            SVNTeamProvider info;
            if (resource.getType() == 4 && (info = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature")) != null) {
                try {
                    info.relocateResource();
                }
                catch (CoreException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (depth != 0 && (map = (Map)this.localResources.get(resource)) != null) {
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    this.refreshLocalResourceImpl((IResource)it.next(), depth == 1 ? 0 : depth);
                }
            }
            this.localResources.remove(resource);
        }
        this.switchedToUrls.remove(resource.getFullPath());
    }

    protected ILocalResource loadLocalResourcesSubTree(IResource resource, int depth) throws Exception {
        ILocalResource parentLocal;
        boolean parentExists;
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature");
        if (provider == null || FileUtility.isSVNInternals(resource)) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        boolean isCacheEnabled = CoreExtensionsManager.instance().getOptionProvider().is("svnCacheEnabled");
        if (!isCacheEnabled) {
            this.localResources.clear();
        }
        depth = isCacheEnabled ? depth : 0;
        ILocalResource retVal = null;
        boolean isLinked = FileUtility.isLinked(resource);
        IContainer parent = resource.getParent();
        boolean bl = parentExists = parent != null && parent.isAccessible();
        if (parentExists && !isLinked && ((parentLocal = this.asLocalResourceImpl((IResource)parent, 1)) == null || !SF_NONSVN.accept(parentLocal) || IStateFilter.SF_UNVERSIONED_EXTERNAL.accept(parentLocal))) {
            retVal = this.loadLocalResourcesSubTreeSVNImpl(provider, resource, depth);
        }
        return retVal == null || IStateFilter.SF_UNVERSIONED.accept(retVal) && !IStateFilter.SF_IGNORED.accept(retVal) ? this.loadUnversionedSubtree(resource, isLinked, depth) : retVal;
    }

    protected ILocalResource loadUnversionedSubtree(final IResource resource, final boolean isLinked, int depth) throws Exception {
        final ILocalResource[] tmp = new ILocalResource[1];
        final boolean[] isUnversionedExternalParent = new boolean[1];
        FileUtility.visitNodes(resource, new IResourceVisitor(){

            public boolean visit(IResource child) throws CoreException {
                String inheritedStatus;
                if (FileUtility.isSVNInternals(child) || SVNRemoteStorage.this.canFetchStatuses(new File(FileUtility.getWorkingCopyPath(child)))) {
                    return false;
                }
                ILocalResource parent = SVNRemoteStorage.this.getFirstExistingParentLocal(child);
                boolean parentIsSymlink = parent != null && (parent.getChangeMask() & 0x100) != 0;
                int parentCM = (parent != null ? parent.getChangeMask() & 0x48 : 0) | (parentIsSymlink ? 64 : 0);
                String string = inheritedStatus = parentIsSymlink ? "Ignored" : SVNRemoteStorage.this.calculateUnversionedStatus(resource, isLinked);
                String textState = child == resource ? inheritedStatus : SVNRemoteStorage.this.getDelegatedStatus(child, parentIsSymlink ? "Ignored" : inheritedStatus, 0);
                int changeMask = parentCM;
                if (textState == "New" && child.getType() == 2 && FileUtility.isSymlink(child)) {
                    changeMask |= 0x100;
                }
                if ((parent != null && !IStateFilter.SF_IGNORED_NOT_FORBIDDEN.accept(parent) || parent == null) && textState == "Ignored" && (changeMask & 0x40) == 0 && (isUnversionedExternalParent[0] || SVNRemoteStorage.this.containsSVNMetaInChildren(resource))) {
                    changeMask |= 0x40;
                    if (!isUnversionedExternalParent[0] && child.equals((Object)resource)) {
                        isUnversionedExternalParent[0] = true;
                    }
                }
                ILocalResource retVal = SVNRemoteStorage.this.registerResource(child, -1L, -1L, textState, "Normal", changeMask, null, -1L, null);
                if (tmp[0] == null) {
                    tmp[0] = retVal;
                }
                return true;
            }
        }, depth, false);
        return tmp[0] != null ? tmp[0] : this.wrapUnexistingResource(resource, "InternalInvalid", 0);
    }

    protected String calculateUnversionedStatus(IResource resource, boolean isLinked) {
        String status = IStateFilter.ST_NOTEXISTS;
        if (isLinked) {
            status = "Linked";
        } else {
            IPath location = resource.getLocation();
            if (location != null && SVNRemoteStorage.isFileExists(location)) {
                status = "Ignored";
                if (!SVNUtility.isIgnored(resource)) {
                    ILocalResource local = this.getCachedResource(resource);
                    if (local != null) {
                        return local.getStatus();
                    }
                    status = this.getTopLevelStatus(resource, "New", 0);
                }
            }
        }
        return status;
    }

    public static boolean isFileExists(IPath location) {
        File file = location.toFile();
        if (file.exists()) {
            if (FileUtility.isWindows()) {
                try {
                    return file.getName().equals(file.getCanonicalFile().getName());
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected ILocalResource loadLocalResourcesSubTreeSVNImpl(SVNTeamProvider provider, IResource resource, int depth) throws Exception {
        IProject project = resource.getProject();
        IResource target = resource.getType() == 1 ? resource.getParent() : resource;
        IPath wcPath = project.getLocation();
        IPath resourcePath = target.getLocation();
        IPath requestedPath = resource.getLocation();
        if (wcPath == null || resourcePath == null || requestedPath == null) {
            return null;
        }
        String projectPath = wcPath.toString();
        int subPathStart = projectPath.length();
        boolean hasSVNMeta = true;
        if (SVNUtility.isPriorToSVN17()) {
            while (!this.canFetchStatuses(resourcePath)) {
                if (target == null || target.getType() == 4) {
                    return null;
                }
                hasSVNMeta = false;
                resourcePath = resourcePath.removeLastSegments(1);
                target = target.getParent();
            }
        }
        IRepositoryResource baseResource = provider.getRepositoryResource();
        int offsetFromRoot = resourcePath.segmentCount() - wcPath.segmentCount();
        SVNDepth svnDepth = depth == 0 ? SVNDepth.EMPTY : (depth == 1 ? SVNDepth.IMMEDIATES : SVNDepth.INFINITY);
        svnDepth = offsetFromRoot < 1 || !CoreExtensionsManager.instance().getOptionProvider().is("svnCacheEnabled") ? SVNDepth.IMMEDIATES : svnDepth;
        SVNChangeStatus[] statuses = this.getStatuses(resourcePath.toString(), svnDepth);
        String desiredUrl = this.makeUrl(target, baseResource);
        SVNChangeStatus[][] loadTargets = new SVNChangeStatus[1][];
        ILocalResource retVal = this.fillCache(statuses, desiredUrl, resource, subPathStart, requestedPath, loadTargets);
        if (statuses.length == 1 && !this.localResources.containsKey(target)) {
            this.localResources.put(target, new HashMap());
        }
        statuses = loadTargets[0];
        if (retVal != null && hasSVNMeta && statuses.length > 1 && depth != 0 && CoreExtensionsManager.instance().getOptionProvider().is("svnCacheEnabled")) {
            this.fetchQueue.push(new SvnChange(statuses, target));
        }
        return retVal;
    }

    protected boolean canFetchStatuses(IPath path) {
        return path.append(SVNUtility.getSVNFolderName()).toFile().exists();
    }

    protected boolean canFetchStatuses(File file) {
        return new File(file, SVNUtility.getSVNFolderName()).exists();
    }

    protected SVNChangeStatus[] getStatuses(String path, SVNDepth depth) throws Exception {
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNChangeStatus[] statuses = SVNUtility.status(proxy, path, depth, 384L, new SVNNullProgressMonitor());
            SVNUtility.reorder(statuses, true);
            SVNChangeStatus[] sVNChangeStatusArray = statuses;
            return sVNChangeStatusArray;
        }
        catch (SVNConnectorException cwe) {
            if (cwe.getErrorId() == 155037) {
                SVNChangeStatus[] sVNChangeStatusArray = new SVNChangeStatus[]{new SVNChangeStatus(path, "", SVNEntry.Kind.DIR, 0L, 0L, 0L, "", SVNEntryStatus.Kind.MODIFIED, SVNEntryStatus.Kind.NORMAL, SVNEntryStatus.Kind.NORMAL, SVNEntryStatus.Kind.NORMAL, false, false, false, null, null, 0L, 0L, SVNEntry.Kind.DIR, "", false, false, null, null)};
                return sVNChangeStatusArray;
            }
            if (cwe.getErrorId() != 155007 && cwe.getErrorId() != 155010) {
                throw cwe;
            }
            SVNChangeStatus[] sVNChangeStatusArray = new SVNChangeStatus[]{};
            return sVNChangeStatusArray;
        }
        finally {
            proxy.dispose();
        }
    }

    /*
     * Exception decompiling
     */
    protected ILocalResource fillCache(SVNChangeStatus[] statuses, String desiredUrl, IResource resource, int subPathStart, IPath requestedPath, SVNChangeStatus[][] loadTargets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean containsSVNMetaInChildren(IResource resource) {
        if (SVNUtility.isIgnored(resource)) {
            return false;
        }
        boolean hasSVNMeta = false;
        if (resource.getType() == 2 && resource.getLocation() != null) {
            File folder = resource.getLocation().toFile();
            do {
                boolean[] check;
                String[] children;
                File file = folder = (children = folder.list(new FilenameFilter(check = new boolean[]{true}){
                    private final /* synthetic */ boolean[] val$check;
                    {
                        this.val$check = blArray;
                    }

                    public boolean accept(File dir, String name) {
                        boolean accept = false;
                        if (this.val$check[0] && (accept = new File(dir, name).isDirectory())) {
                            this.val$check[0] = false;
                        }
                        return accept;
                    }
                })) != null && children.length > 0 ? new File(folder, children[0]) : null;
            } while (folder != null && !(hasSVNMeta = this.canFetchStatuses(folder)));
        }
        return hasSVNMeta;
    }

    protected String getDelegatedStatus(IResource resource, String status, int mask) {
        if (IStateFilter.SF_LINKED.accept(resource, status, mask) || FileUtility.isLinked(resource)) {
            return "Linked";
        }
        if (IStateFilter.SF_OBSTRUCTED.accept(resource, status, mask)) {
            return "Obstructed";
        }
        if ("Ignored" == status) {
            return "Ignored";
        }
        return this.getTopLevelStatus(resource, status, mask);
    }

    protected String getTopLevelStatus(IResource resource, String status, int mask) {
        ILocalResource topLevel = this.getFirstExistingParentLocal(resource);
        if (topLevel != null) {
            String topLevelStatus = topLevel.getStatus();
            IResource topLevelResource = topLevel.getResource();
            if (IStateFilter.SF_OBSTRUCTED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_LINKED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_IGNORED.accept(topLevelResource, topLevelStatus, mask)) {
                return topLevelStatus;
            }
        }
        return status;
    }

    protected ILocalResource registerUnversionedResource(IResource resource, int changeMask) {
        return this.registerResource(resource, -1L, -1L, "Ignored", "Normal", changeMask, null, 0L, null);
    }

    protected ILocalResource registerResource(IResource current, long revision, long baseRevision, String textStatus, String propStatus, int changeMask, String author, long date, SVNConflictDescriptor treeConflictDescriptor) {
        File wcDB;
        SVNLocalResource local = null;
        if (IStateFilter.SF_OBSTRUCTED.accept(current, textStatus, changeMask)) {
            try {
                IIgnoreRecommendations[] ignores = CoreExtensionsManager.instance().getIgnoreRecommendations();
                int i = 0;
                while (i < ignores.length) {
                    if (ignores[i].isAcceptableNature(current) && ignores[i].isOutput(current)) {
                        IPath location = current.getProject().getLocation();
                        if (location != null) {
                            String projectPath = location.removeLastSegments(1).toString();
                            File checkedResource = new File(String.valueOf(projectPath) + current.getFullPath().toString());
                            textStatus = !checkedResource.exists() ? IStateFilter.ST_NOTEXISTS : "Ignored";
                            IPath invalidMetaPath = new Path(String.valueOf(projectPath) + current.getFullPath().toString()).append(SVNUtility.getSVNFolderName());
                            FileUtility.deleteRecursive(invalidMetaPath.toFile());
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (IStateFilter.SF_UNVERSIONED.accept(current, textStatus, changeMask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(current, textStatus, changeMask) && !IStateFilter.SF_DELETED.accept(current, textStatus, changeMask) || IStateFilter.SF_LINKED.accept(current, textStatus, changeMask)) {
            revision = -1L;
            author = null;
            date = -1L;
        }
        local = current instanceof IContainer ? new SVNLocalFolder(current, revision, baseRevision, textStatus, propStatus, changeMask, author, date, treeConflictDescriptor) : new SVNLocalFile(current, revision, baseRevision, textStatus, propStatus, changeMask, author, date, treeConflictDescriptor);
        this.setCachedResource(local);
        if (current.getType() == 4 && !this.changeMonitorMap.containsKey(current) && (wcDB = FileUtility.findWCDB(FileUtility.getResourcePath(current).toFile())) != null) {
            this.changeMonitorMap.put(current, wcDB);
        }
        return local;
    }

    protected ILocalResource getFirstExistingParentLocal(IResource node) {
        IContainer parent = node.getParent();
        if (parent == null) {
            return null;
        }
        ILocalResource local = this.getCachedResource((IResource)parent);
        if (local != null) {
            return local;
        }
        return this.getFirstExistingParentLocal((IResource)parent);
    }

    protected String deserializeStatus(String status) {
        if ("null".equals(status)) {
            return IStateFilter.ST_NOTEXISTS;
        }
        if ("Ignored".equals(status)) {
            return "Ignored";
        }
        if ("New".equals(status)) {
            return "New";
        }
        if ("Added".equals(status)) {
            return "Added";
        }
        if ("Normal".equals(status)) {
            return "Normal";
        }
        if ("Modified".equals(status)) {
            return "Modified";
        }
        if ("Conflicting".equals(status)) {
            return "Conflicting";
        }
        if ("Deleted".equals(status)) {
            return "Deleted";
        }
        if ("Missing".equals(status)) {
            return "Missing";
        }
        if ("Obstructed".equals(status)) {
            return "Obstructed";
        }
        if ("Prereplaced".equals(status)) {
            return "Prereplaced";
        }
        if ("Replaced".equals(status)) {
            return "Replaced";
        }
        throw new RuntimeException(SVNMessages.getErrorString("Error_UnknownStatus"));
    }

    public static String getCompoundStatusString(SVNEntryStatus.Kind propStatus, SVNEntryStatus.Kind textStatus, boolean isRemoteStatus) {
        String textStr = SVNRemoteStorage.getTextStatusString(propStatus, textStatus, isRemoteStatus);
        String propStr = SVNRemoteStorage.getPropStatusString(propStatus);
        return SVNRemoteStorage.getCompoundStatusString(textStr, propStr);
    }

    public static String getCompoundStatusString(String textStatus, String propStatus) {
        String status = textStatus;
        if (propStatus == "Conflicting") {
            status = "Conflicting";
        } else if (textStatus == "Normal" && propStatus == "Modified") {
            status = "Modified";
        }
        return status;
    }

    public static String getTextStatusString(SVNEntryStatus.Kind propKind, SVNEntryStatus.Kind textKind, boolean isRemoteStatus) {
        String status = "Normal";
        switch (textKind) {
            case IGNORED: {
                status = "Ignored";
                break;
            }
            case UNVERSIONED: {
                status = isRemoteStatus ? IStateFilter.ST_NOTEXISTS : "New";
                break;
            }
            case ADDED: {
                status = "Added";
                break;
            }
            case DELETED: {
                status = "Deleted";
                break;
            }
            case MISSING: {
                status = "Missing";
                break;
            }
            case CONFLICTED: {
                status = isRemoteStatus ? "Modified" : "Conflicting";
                break;
            }
            case MODIFIED: 
            case MERGED: {
                status = "Modified";
                break;
            }
            case OBSTRUCTED: {
                status = "Obstructed";
                break;
            }
            case REPLACED: {
                status = "Replaced";
                break;
            }
            case NONE: {
                if (isRemoteStatus || propKind != SVNEntryStatus.Kind.NONE) break;
                status = IStateFilter.ST_NOTEXISTS;
                break;
            }
        }
        return status;
    }

    protected static String getPropStatusString(SVNEntryStatus.Kind propKind) {
        String status = "Normal";
        if (propKind == SVNEntryStatus.Kind.CONFLICTED) {
            status = "Conflicting";
        } else if (propKind == SVNEntryStatus.Kind.MODIFIED) {
            status = "Modified";
        }
        return status;
    }

    protected static int getChangeMask(SVNEntryStatus.Kind textStatus, SVNEntryStatus.Kind propKind, boolean isCopied, boolean isSwitched, boolean isSVNExternals) {
        int changeMask = 0;
        if (isCopied) {
            changeMask |= 4;
        }
        if (isSwitched) {
            changeMask |= 8;
        }
        if (isSVNExternals) {
            changeMask |= 0x80;
        }
        return changeMask;
    }

    private SVNRemoteStorage() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SvnChange
    implements IQueuedElement<SvnChange> {
        public final SVNChangeStatus[] st;
        public final IResource target;

        public SvnChange(SVNChangeStatus[] st, IResource target) {
            this.st = st;
            this.target = target;
        }

        @Override
        public boolean canSkip() {
            return false;
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean canMerge(SvnChange d) {
            return this.target.equals((Object)d.target);
        }

        @Override
        public SvnChange merge(SvnChange d) {
            SVNChangeStatus[] result = new SVNChangeStatus[this.st.length + d.st.length];
            System.arraycopy(this.st, 0, result, 0, this.st.length);
            System.arraycopy(d.st, 0, result, this.st.length, d.st.length);
            return new SvnChange(result, this.target);
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("SvnChange [");
            out.append("size: ").append(this.st.length);
            out.append(", target: ");
            out.append(this.target);
            out.append("]");
            return out.toString();
        }
    }
}

