/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;

public class ShowAnnotationPanel
extends AbstractDialogPanel {
    protected IRepositoryResource resource;
    protected RevisionComposite fromRevision;
    protected RevisionComposite toRevision;
    protected SVNRevisionRange revisions;

    public ShowAnnotationPanel(IRepositoryResource resource) {
        this.dialogTitle = SVNUIMessages.ShowAnnotationPanel_Title;
        this.dialogDescription = SVNUIMessages.ShowAnnotationPanel_Description;
        this.defaultMessage = SVNUIMessages.ShowAnnotationPanel_DefaultMessage;
        this.resource = resource;
    }

    protected void createControlsImpl(Composite parent) {
        this.fromRevision = new RevisionComposite(parent, this, false, new String[]{SVNUIMessages.ShowAnnotationPanel_FromRevision, SVNUIMessages.RevisionComposite_HeadRevision}, SVNRevision.HEAD, false);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(768);
        this.fromRevision.setLayout((Layout)layout);
        this.fromRevision.setLayoutData(data);
        IRepositoryResource fromResource = SVNUtility.copyOf((IRepositoryResource)this.resource);
        fromResource.setSelectedRevision(this.resource.getSelectedRevision());
        this.fromRevision.setSelectedResource(fromResource);
        this.fromRevision.setRevisionValue((SVNRevision)SVNRevision.fromNumber((long)1L));
        this.toRevision = new RevisionComposite(parent, this, false, new String[]{SVNUIMessages.ShowAnnotationPanel_ToRevision, SVNUIMessages.RevisionComposite_HeadRevision}, SVNRevision.HEAD, false);
        layout = new GridLayout();
        data = new GridData(768);
        this.toRevision.setLayout((Layout)layout);
        this.toRevision.setLayoutData(data);
        IRepositoryResource toResource = SVNUtility.copyOf((IRepositoryResource)this.resource);
        toResource.setSelectedRevision(this.resource.getSelectedRevision());
        this.toRevision.setSelectedResource(toResource);
    }

    public SVNRevisionRange getRevisions() {
        return this.revisions;
    }

    protected void cancelChangesImpl() {
    }

    protected void saveChangesImpl() {
        this.revisions = new SVNRevisionRange(this.fromRevision.getSelectedRevision(), this.toRevision.getSelectedRevision());
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.showAnnotationDialogContext";
    }
}

