/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.extension.factory.SVNConnectorHelper;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.DateFormatVerifier;
import org.eclipse.team.svn.ui.verifier.ExistingResourceVerifier;
import org.eclipse.team.svn.ui.verifier.IntegerFieldVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.ui.PlatformUI;

public class SVNTeamPreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected String head;
    protected String branches;
    protected String tags;
    protected boolean showExternals;
    protected boolean simpleShare;
    protected boolean fastReport;
    protected boolean enableModelSync;
    protected boolean pagingEnable;
    protected boolean connectToCompareWith;
    protected int pageSize;
    protected int dateFormat;
    protected String dateFormatCustom;
    protected boolean mailReporterEnabled;
    protected boolean mailReporterErrorsEnabled;
    protected boolean commitSelectNewResources;
    protected boolean commitSelectDerivedResources;
    protected boolean notSelectMissingResources;
    protected boolean useSubversionExternalsBehaviour;
    protected boolean showSelectedResourcesInSyncPane;
    protected boolean treatReplacementAsEdit;
    protected String svnConnector;
    protected ISVNConnectorFactory[] factories;
    protected boolean useJavaHLMerge;
    protected boolean includeMergedRevisions;
    protected boolean checkoutUsingDotProjectName;
    protected boolean checkoutRespectProjectStructure;
    protected boolean checkoutUseDefaultLocation;
    protected String checkoutSpecifiedLocation;
    protected boolean branchTagConsiderStructure;
    protected boolean forceExternalsFreeze;
    protected boolean computeKeywordsValues;
    protected boolean enableAutoShare;
    protected boolean caseInsensitiveSorting;
    protected String consultChangeSets;
    protected boolean ignoreExternals;
    protected Text headField;
    protected Text branchesField;
    protected Text tagsField;
    protected Button showExternalsButton;
    protected Combo svnConnectorField;
    protected Button useInteractiveMergeButton;
    protected Button includeMergedRevisionsButton;
    protected Button fastReportButton;
    protected Button enableModelSyncButton;
    protected Button enablePagingButton;
    protected Button connectToCompareWithButton;
    protected Text pageSizeField;
    protected Combo dateFormatField;
    protected Text dateFormatCustomField;
    protected Button mailReporterEnabledButton;
    protected Button mailReporterErrorsEnabledButton;
    protected Button btnResourceSelectionNew;
    protected Button btnResourceSelectionDerived;
    protected Button btnResourceNotSelectionMissing;
    protected Button btnResourceSelectionExternal;
    protected Button btnResourceSelectionPresentation;
    protected Button btnResourceSelectionTreatAsEdit;
    protected Button checkoutUsingDotProjectNameButton;
    protected Button checkoutRespectProjectStructureButton;
    protected Button browse;
    protected Button useDefaultLocationButton;
    protected Text locationField;
    protected Button branchTagConsiderStructureButton;
    protected Button branchTagManualUrlEditButton;
    protected Button computeKeywordsValuesButton;
    protected Button enableAutoShareButton;
    protected Button caseInsensitiveSortingButton;
    protected Button forceExternalsFreezeButton;
    protected Button consultCSAlwaysButton;
    protected Button consultCSNeverButton;
    protected Button consultCSPromptButton;
    protected Button ignoreExternalsButton;
    protected Button checkForConnectorsButton;

    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setRepositoryString(store, "head", this.head);
        SVNTeamPreferences.setRepositoryString(store, "branches", this.branches);
        SVNTeamPreferences.setRepositoryString(store, "tags", this.tags);
        SVNTeamPreferences.setRepositoryBoolean(store, "tagConsideringProjectStructure", this.branchTagConsiderStructure);
        SVNTeamPreferences.setRepositoryBoolean(store, "forceExternalsFreeze", this.forceExternalsFreeze);
        SVNTeamPreferences.setRepositoryBoolean(store, "showExternals", this.showExternals);
        SVNTeamPreferences.setRepositoryBoolean(store, "simpleShare", this.simpleShare);
        AbstractSVNSubscriber.setSynchInfoContigous((boolean)this.fastReport);
        SVNTeamPreferences.setSynchronizeBoolean(store, "enableModelSync", this.enableModelSync);
        SVNTeamPreferences.setHistoryInt(store, "pageSize", this.pageSize);
        SVNTeamPreferences.setHistoryBoolean(store, "pagingEnable", this.pagingEnable);
        SVNTeamPreferences.setHistoryBoolean(store, "connectToCompareWith", this.connectToCompareWith);
        SVNTeamPreferences.setDateFormatInt(store, "dateFormat", this.dateFormat);
        SVNTeamPreferences.setDateFormatString(store, "dateFormatCustom", this.dateFormatCustom);
        SVNTeamPreferences.setConsultChangeSetsInCommit(store, "consultChangeSetsInCommit", this.consultChangeSets);
        SVNTeamPreferences.setMailReporterBoolean(store, "enabled", this.mailReporterEnabled);
        SVNTeamPreferences.setMailReporterBoolean(store, "errorsEnabled", this.mailReporterErrorsEnabled);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.selectNew", this.commitSelectNewResources);
        if (this.commitSelectDerivedResources != SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.selectDerived")) {
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(UpdateSubscriber.instance().roots(), 2, 0));
        }
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.selectDerived", this.commitSelectDerivedResources);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.dontSelectMissing", this.notSelectMissingResources);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.treatExternalAsLocal", this.useSubversionExternalsBehaviour);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.showResourcesInSyncPane", this.showSelectedResourcesInSyncPane);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.treatAsEdit", this.treatReplacementAsEdit);
        SVNTeamPreferences.setBehaviourBoolean(store, "share.enableAuto", this.enableAutoShare);
        SVNTeamPreferences.setBehaviourBoolean(store, "keywords.computeValues", this.computeKeywordsValues);
        SVNTeamPreferences.setBehaviourBoolean(store, "sorting.case.insensitive", this.caseInsensitiveSorting);
        SVNTeamPreferences.setBehaviourBoolean(store, "externals.ignore", this.ignoreExternals);
        String oldId = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
        if (!oldId.equals(this.svnConnector)) {
            SVNTeamPreferences.setCoreString(store, "svnconnector", this.svnConnector);
            SVNRemoteStorage.instance().dispose();
        }
        SVNTeamPreferences.setMergeBoolean(store, "useJavaHL", this.useJavaHLMerge);
        SVNTeamPreferences.setMergeBoolean(store, "includeMerged", this.includeMergedRevisions);
        SVNTeamPreferences.setCheckoutBoolean(store, "useDotProject", this.checkoutUsingDotProjectName);
        SVNTeamPreferences.setCheckoutBoolean(store, "respectProjectStructure", this.checkoutRespectProjectStructure);
        SVNTeamPreferences.setCheckoutBoolean(store, "useDefaultLocation", this.checkoutUseDefaultLocation);
        SVNTeamPreferences.setCheckoutString(store, "specifiedLocation", this.checkoutSpecifiedLocation);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.head = "trunk";
        this.branches = "branches";
        this.tags = "tags";
        this.showExternals = true;
        this.fastReport = Boolean.parseBoolean("true");
        this.enableModelSync = true;
        this.pagingEnable = true;
        this.pageSize = 25;
        this.connectToCompareWith = true;
        this.dateFormat = 0;
        this.dateFormatCustom = "";
        this.consultChangeSets = "never";
        this.mailReporterEnabled = true;
        this.mailReporterErrorsEnabled = true;
        this.commitSelectNewResources = true;
        this.commitSelectDerivedResources = false;
        this.notSelectMissingResources = true;
        this.useSubversionExternalsBehaviour = true;
        this.showSelectedResourcesInSyncPane = false;
        this.treatReplacementAsEdit = true;
        this.useJavaHLMerge = false;
        this.includeMergedRevisions = false;
        this.checkoutUsingDotProjectName = true;
        this.checkoutRespectProjectStructure = false;
        this.checkoutUseDefaultLocation = true;
        this.checkoutSpecifiedLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        this.branchTagConsiderStructure = true;
        this.forceExternalsFreeze = true;
        this.computeKeywordsValues = true;
        this.enableAutoShare = true;
        this.caseInsensitiveSorting = true;
        this.ignoreExternals = false;
        this.svnConnector = "org.eclipse.team.svn.connector.svnkit18";
    }

    protected void loadValues(IPreferenceStore store) {
        this.head = SVNTeamPreferences.getRepositoryString(store, "head");
        this.branches = SVNTeamPreferences.getRepositoryString(store, "branches");
        this.tags = SVNTeamPreferences.getRepositoryString(store, "tags");
        this.showExternals = SVNTeamPreferences.getRepositoryBoolean(store, "showExternals");
        this.simpleShare = SVNTeamPreferences.getRepositoryBoolean(store, "simpleShare");
        this.fastReport = AbstractSVNSubscriber.getSynchInfoContigous();
        this.enableModelSync = SVNTeamPreferences.getSynchronizeBoolean(store, "enableModelSync");
        this.connectToCompareWith = SVNTeamPreferences.getHistoryBoolean(store, "connectToCompareWith");
        this.pagingEnable = SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable");
        this.pageSize = SVNTeamPreferences.getHistoryInt(store, "pageSize");
        this.dateFormat = SVNTeamPreferences.getDateFormatInt(store, "dateFormat");
        this.dateFormatCustom = SVNTeamPreferences.getDateFormatString(store, "dateFormatCustom");
        this.consultChangeSets = SVNTeamPreferences.getConsultChangeSetsInCommit(store, "consultChangeSetsInCommit");
        this.mailReporterEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "enabled");
        this.mailReporterErrorsEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "errorsEnabled");
        this.commitSelectNewResources = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.selectNew");
        this.commitSelectDerivedResources = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.selectDerived");
        this.notSelectMissingResources = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.dontSelectMissing");
        this.useSubversionExternalsBehaviour = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.treatExternalAsLocal");
        this.showSelectedResourcesInSyncPane = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.showResourcesInSyncPane");
        this.treatReplacementAsEdit = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.treatAsEdit");
        this.enableAutoShare = SVNTeamPreferences.getBehaviourBoolean(store, "share.enableAuto");
        this.computeKeywordsValues = SVNTeamPreferences.getBehaviourBoolean(store, "keywords.computeValues");
        this.caseInsensitiveSorting = SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive");
        this.ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(store, "externals.ignore");
        this.useJavaHLMerge = SVNTeamPreferences.getMergeBoolean(store, "useJavaHL");
        this.includeMergedRevisions = SVNTeamPreferences.getMergeBoolean(store, "includeMerged");
        this.checkoutUsingDotProjectName = SVNTeamPreferences.getCheckoutBoolean(store, "useDotProject");
        this.checkoutRespectProjectStructure = SVNTeamPreferences.getCheckoutBoolean(store, "respectProjectStructure");
        this.checkoutUseDefaultLocation = SVNTeamPreferences.getCheckoutBoolean(store, "useDefaultLocation");
        this.checkoutSpecifiedLocation = SVNTeamPreferences.getCheckoutString(store, "specifiedLocation");
        this.branchTagConsiderStructure = SVNTeamPreferences.getRepositoryBoolean(store, "tagConsideringProjectStructure");
        this.forceExternalsFreeze = SVNTeamPreferences.getRepositoryBoolean(store, "forceExternalsFreeze");
        this.svnConnector = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
    }

    protected void initializeControls() {
        this.headField.setText(this.head);
        this.branchesField.setText(this.branches);
        this.tagsField.setText(this.tags);
        this.showExternalsButton.setSelection(this.showExternals);
        this.fastReportButton.setSelection(this.fastReport);
        this.enableModelSyncButton.setSelection(this.enableModelSync);
        this.pageSizeField.setText(String.valueOf(this.pageSize));
        this.enablePagingButton.setSelection(this.pagingEnable);
        this.pageSizeField.setEnabled(this.pagingEnable);
        this.connectToCompareWithButton.setSelection(this.connectToCompareWith);
        this.dateFormatField.select(this.dateFormat);
        this.dateFormatCustomField.setEnabled(this.dateFormat == 3);
        this.setDateFormatValue();
        this.consultCSAlwaysButton.setSelection("always".equals(this.consultChangeSets));
        this.consultCSNeverButton.setSelection("never".equals(this.consultChangeSets));
        this.consultCSPromptButton.setSelection("prompt".equals(this.consultChangeSets));
        this.mailReporterEnabledButton.setSelection(this.mailReporterEnabled);
        this.mailReporterErrorsEnabledButton.setSelection(this.mailReporterErrorsEnabled);
        this.btnResourceSelectionNew.setSelection(this.commitSelectNewResources);
        this.btnResourceSelectionDerived.setSelection(this.commitSelectDerivedResources);
        this.btnResourceNotSelectionMissing.setSelection(this.notSelectMissingResources);
        this.btnResourceSelectionExternal.setSelection(this.useSubversionExternalsBehaviour);
        this.btnResourceSelectionPresentation.setSelection(this.showSelectedResourcesInSyncPane);
        this.btnResourceSelectionTreatAsEdit.setSelection(this.treatReplacementAsEdit);
        List<ISVNConnectorFactory> factoriesList = Arrays.asList(this.factories);
        this.svnConnectorField.select(factoriesList.indexOf(CoreExtensionsManager.instance().getSVNConnectorFactory(this.svnConnector)));
        this.initializeClientSettings();
        this.checkoutUsingDotProjectNameButton.setSelection(this.checkoutUsingDotProjectName);
        this.checkoutRespectProjectStructureButton.setSelection(this.checkoutRespectProjectStructure);
        this.useDefaultLocationButton.setSelection(this.checkoutUseDefaultLocation);
        this.locationField.setText(this.checkoutSpecifiedLocation);
        this.locationField.setEnabled(!this.checkoutUseDefaultLocation);
        this.browse.setEnabled(!this.checkoutUseDefaultLocation);
        this.branchTagConsiderStructureButton.setSelection(this.branchTagConsiderStructure);
        this.forceExternalsFreezeButton.setSelection(this.forceExternalsFreeze);
        this.branchTagManualUrlEditButton.setSelection(!this.branchTagConsiderStructure);
        this.computeKeywordsValuesButton.setSelection(this.computeKeywordsValues);
        this.enableAutoShareButton.setSelection(this.enableAutoShare);
        this.caseInsensitiveSortingButton.setSelection(this.caseInsensitiveSorting);
        this.ignoreExternalsButton.setSelection(this.ignoreExternals);
    }

    protected void initializeClientSettings() {
        boolean isSVN15CompatibleConnector = CoreExtensionsManager.instance().getSVNConnectorFactory(this.svnConnector).getSVNAPIVersion() >= 5;
        this.useInteractiveMergeButton.setSelection(!this.useJavaHLMerge);
        this.includeMergedRevisionsButton.setSelection(this.includeMergedRevisions);
        this.includeMergedRevisionsButton.setEnabled(isSVN15CompatibleConnector);
    }

    protected Control createContentsImpl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MainPreferencePage_generalTabName);
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MainPreferencePage_svnConnectorTabName);
        tabItem.setControl(this.createSVNConnectorsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MainPreferencePage_repositoryTabName);
        tabItem.setControl(this.createRepositorySettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MainPreferencePage_viewSettingsTabName);
        tabItem.setControl(this.createViewSettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MainPreferencePage_mailReporterGroupName);
        tabItem.setControl(this.createErrorReportingSettingsPage((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.SVNPreferencesContext");
        return tabFolder;
    }

    protected Control createSVNConnectorsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_svnConnectorPrompt);
        label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_svnConnector);
        this.svnConnectorField = new Combo(composite, 8);
        data = new GridData(768);
        data.widthHint = 100;
        this.svnConnectorField.setLayoutData((Object)data);
        Collection fullSet = CoreExtensionsManager.instance().getAccessibleClients();
        this.factories = fullSet.toArray(new ISVNConnectorFactory[fullSet.size()]);
        Arrays.sort(this.factories, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((ISVNConnectorFactory)o1).getName().compareTo(((ISVNConnectorFactory)o2).getName());
            }
        });
        String[] items = new String[fullSet.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = SVNConnectorHelper.getConnectorName((ISVNConnectorFactory)this.factories[i]);
            ++i;
        }
        this.svnConnectorField.setItems(items);
        this.svnConnectorField.setVisibleItemCount(items.length);
        this.svnConnectorField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.svnConnector = SVNTeamPreferencesPage.this.factories[SVNTeamPreferencesPage.this.svnConnectorField.getSelectionIndex()].getId();
                SVNTeamPreferencesPage.this.initializeClientSettings();
            }
        });
        if (CoreExtensionsManager.instance().getAccessibleClients().isEmpty()) {
            this.checkForConnectorsButton = new Button(composite, 8);
            this.checkForConnectorsButton.setText(SVNUIMessages.Button_CheckForConnectors);
            data = new GridData(768);
            data.widthHint = DefaultDialog.computeButtonWidth(this.checkForConnectorsButton);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            data.horizontalAlignment = 131072;
            this.checkForConnectorsButton.setLayoutData((Object)data);
            this.checkForConnectorsButton.setEnabled(true);
            this.checkForConnectorsButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SVNTeamUIPlugin.instance().discoveryConnectors();
                }
            });
        }
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(SVNUIMessages.MainPreferencePage_mergeGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_mergePrompt);
        this.useInteractiveMergeButton = new Button((Composite)group, 32);
        data = new GridData();
        this.useInteractiveMergeButton.setLayoutData((Object)data);
        this.useInteractiveMergeButton.setText(SVNUIMessages.MainPreferencePage_mergeUseInteractiveMerge);
        this.useInteractiveMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useJavaHLMerge = !SVNTeamPreferencesPage.this.useInteractiveMergeButton.getSelection();
            }
        });
        label = new Label((Composite)group, 258);
        label.setVisible(false);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_includeMergedRevisionsLabel);
        this.includeMergedRevisionsButton = new Button((Composite)group, 32);
        data = new GridData();
        this.includeMergedRevisionsButton.setLayoutData((Object)data);
        this.includeMergedRevisionsButton.setText(SVNUIMessages.MainPreferencePage_includeMergedRevisions);
        this.includeMergedRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.includeMergedRevisions = SVNTeamPreferencesPage.this.includeMergedRevisionsButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createGeneralPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_resourceSelectionGroupName);
        Label label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_resourceSelectionPrompt);
        this.btnResourceSelectionNew = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionNew.setLayoutData((Object)data);
        this.btnResourceSelectionNew.setText(SVNUIMessages.MainPreferencePage_resourceSelectionNew);
        this.btnResourceSelectionNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.commitSelectNewResources = SVNTeamPreferencesPage.this.btnResourceSelectionNew.getSelection();
            }
        });
        this.btnResourceSelectionDerived = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionDerived.setLayoutData((Object)data);
        this.btnResourceSelectionDerived.setText(SVNUIMessages.MainPreferencePage_resourceSelectionDerived);
        this.btnResourceSelectionDerived.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.commitSelectDerivedResources = SVNTeamPreferencesPage.this.btnResourceSelectionDerived.getSelection();
            }
        });
        this.btnResourceNotSelectionMissing = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceNotSelectionMissing.setLayoutData((Object)data);
        this.btnResourceNotSelectionMissing.setText(SVNUIMessages.MainPreferencePage_resourceSelectionMissing);
        this.btnResourceNotSelectionMissing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.notSelectMissingResources = SVNTeamPreferencesPage.this.btnResourceNotSelectionMissing.getSelection();
            }
        });
        this.btnResourceSelectionExternal = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionExternal.setLayoutData((Object)data);
        this.btnResourceSelectionExternal.setText(SVNUIMessages.MainPreferencePage_resourceSelectionExternal);
        this.btnResourceSelectionExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useSubversionExternalsBehaviour = SVNTeamPreferencesPage.this.btnResourceSelectionExternal.getSelection();
            }
        });
        this.btnResourceSelectionPresentation = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionPresentation.setLayoutData((Object)data);
        this.btnResourceSelectionPresentation.setText(SVNUIMessages.MainPreferencePage_resourceSelectionPresentation);
        this.btnResourceSelectionPresentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showSelectedResourcesInSyncPane = SVNTeamPreferencesPage.this.btnResourceSelectionPresentation.getSelection();
            }
        });
        this.btnResourceSelectionTreatAsEdit = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionTreatAsEdit.setLayoutData((Object)data);
        this.btnResourceSelectionTreatAsEdit.setText(SVNUIMessages.MainPreferencePage_resourceSelectionTreatAsEdit);
        this.btnResourceSelectionTreatAsEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.treatReplacementAsEdit = SVNTeamPreferencesPage.this.btnResourceSelectionTreatAsEdit.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_shareGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_sharePrompt);
        this.enableAutoShareButton = new Button((Composite)group, 32);
        data = new GridData();
        this.enableAutoShareButton.setLayoutData((Object)data);
        this.enableAutoShareButton.setText(SVNUIMessages.MainPreferencePage_shareEnableAuto);
        this.enableAutoShareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.enableAutoShare = SVNTeamPreferencesPage.this.enableAutoShareButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_keywordsGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_keywordsPrompt);
        this.computeKeywordsValuesButton = new Button((Composite)group, 32);
        data = new GridData();
        this.computeKeywordsValuesButton.setLayoutData((Object)data);
        this.computeKeywordsValuesButton.setText(SVNUIMessages.MainPreferencePage_keywordsComputeRecursively);
        this.computeKeywordsValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.computeKeywordsValues = SVNTeamPreferencesPage.this.computeKeywordsValuesButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_tableSortingGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_tableSortingPrompt);
        this.caseInsensitiveSortingButton = new Button((Composite)group, 32);
        data = new GridData();
        this.caseInsensitiveSortingButton.setLayoutData((Object)data);
        this.caseInsensitiveSortingButton.setText(SVNUIMessages.MainPreferencePage_tableSortingCaseInsensitive);
        this.caseInsensitiveSortingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.caseInsensitiveSorting = SVNTeamPreferencesPage.this.caseInsensitiveSortingButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_externalsGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_externalsGroupPrompt);
        this.ignoreExternalsButton = new Button((Composite)group, 32);
        data = new GridData();
        this.ignoreExternalsButton.setLayoutData((Object)data);
        this.ignoreExternalsButton.setText(SVNUIMessages.MainPreferencePage_ignoreExternals);
        this.ignoreExternalsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.ignoreExternals = SVNTeamPreferencesPage.this.ignoreExternalsButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createViewSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group synchViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        synchViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        synchViewGroup.setLayoutData((Object)data);
        Group consultChangeSetsGroup = new Group(composite, 4);
        layout = new GridLayout();
        consultChangeSetsGroup.setLayout((Layout)layout);
        data = new GridData(768);
        consultChangeSetsGroup.setLayoutData((Object)data);
        Group historyViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        historyViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        historyViewGroup.setLayoutData((Object)data);
        Group dateFormatGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dateFormatGroup.setLayout((Layout)layout);
        data = new GridData(768);
        dateFormatGroup.setLayoutData((Object)data);
        synchViewGroup.setText(SVNUIMessages.MainPreferencePage_synchronizeGroupName);
        Label label = new Label((Composite)synchViewGroup, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.MainPreferencePage_synchronizePrompt);
        this.fastReportButton = new Button((Composite)synchViewGroup, 32);
        data = new GridData();
        this.fastReportButton.setLayoutData((Object)data);
        this.fastReportButton.setText(SVNUIMessages.MainPreferencePage_synchronizeFastReportName);
        this.fastReportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.fastReport = SVNTeamPreferencesPage.this.fastReportButton.getSelection();
            }
        });
        this.enableModelSyncButton = new Button((Composite)synchViewGroup, 32);
        data = new GridData();
        this.enableModelSyncButton.setLayoutData((Object)data);
        this.enableModelSyncButton.setText(SVNUIMessages.MainPreferencePage_allowModelsName);
        this.enableModelSyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.enableModelSync = SVNTeamPreferencesPage.this.enableModelSyncButton.getSelection();
            }
        });
        this.createConsultChangeSets(consultChangeSetsGroup);
        historyViewGroup.setText(SVNUIMessages.MainPreferencePage_historyGroupName);
        label = new Label((Composite)historyViewGroup, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_historyPrompt);
        this.enablePagingButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        this.enablePagingButton.setLayoutData((Object)data);
        String labelText = SVNUIMessages.MainPreferencePage_historyEnablePaging;
        this.enablePagingButton.setText(labelText);
        this.enablePagingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SVNTeamPreferencesPage.this.enablePagingButton.getSelection()) {
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(true);
                    int tmpPageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                    SVNTeamPreferencesPage.this.pageSize = tmpPageSize == 0 ? 25 : tmpPageSize;
                    SVNTeamPreferencesPage.this.pageSizeField.setText(String.valueOf(SVNTeamPreferencesPage.this.pageSize));
                    SVNTeamPreferencesPage.this.pagingEnable = true;
                } else {
                    SVNTeamPreferencesPage.this.pagingEnable = false;
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(false);
                }
            }
        });
        this.pageSizeField = new Text((Composite)historyViewGroup, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.pageSizeField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.pageSizeField, verifier);
        this.pageSizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamPreferencesPage.this.pageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                }
                catch (Exception exception) {}
            }
        });
        this.connectToCompareWithButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.connectToCompareWithButton.setLayoutData((Object)data);
        labelText = SVNUIMessages.MainPreferencePage_historyConnectToCompareWith;
        this.connectToCompareWithButton.setText(labelText);
        this.connectToCompareWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.connectToCompareWith = ((Button)e.widget).getSelection();
            }
        });
        dateFormatGroup.setText(SVNUIMessages.MainPreferencePage_dateFormatGroupName);
        label = new Label((Composite)dateFormatGroup, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        labelText = SVNUIMessages.MainPreferencePage_dateFormatPrompt;
        label.setText(labelText);
        this.dateFormatField = new Combo((Composite)dateFormatGroup, 12);
        String[] itemsDateFormat = new String[]{SVNUIMessages.MainPreferencePage_dateFormatShort, SVNUIMessages.MainPreferencePage_dateFormatMedium, SVNUIMessages.MainPreferencePage_dateFormatLong, SVNUIMessages.MainPreferencePage_dateFormatCustom};
        this.dateFormatField.setItems(itemsDateFormat);
        data = new GridData();
        data.widthHint = 100;
        this.dateFormatField.setLayoutData((Object)data);
        this.dateFormatField.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPreferencesPage.this.dateFormat = SVNTeamPreferencesPage.this.dateFormatField.getSelectionIndex();
                if (SVNTeamPreferencesPage.this.dateFormat == 3) {
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setEnabled(true);
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setFocus();
                } else {
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setEnabled(false);
                }
                SVNTeamPreferencesPage.this.setDateFormatValue();
                SVNTeamPreferencesPage.this.validateContent();
            }
        });
        this.dateFormatCustomField = new Text((Composite)dateFormatGroup, 2052);
        data = new GridData(768);
        this.dateFormatCustomField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new DateFormatVerifier(labelText));
        this.attachTo((Control)this.dateFormatCustomField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return SVNTeamPreferencesPage.this.dateFormatField.getSelectionIndex() == 3;
            }
        });
        this.dateFormatCustomField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SVNTeamPreferencesPage.this.dateFormat == 3) {
                    SVNTeamPreferencesPage.this.dateFormatCustom = SVNTeamPreferencesPage.this.dateFormatCustomField.getText();
                }
            }
        });
        return composite;
    }

    protected void setDateFormatValue() {
        Date exampleDate;
        if (this.dateFormat == 3) {
            this.dateFormatCustomField.setText(this.dateFormatCustom);
            return;
        }
        DateFormat dateTimeFormat = this.dateFormat == 0 ? DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ULocale.getDefault()) : (this.dateFormat == 1 ? DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)ULocale.getDefault()) : (this.dateFormat == 2 ? DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)ULocale.getDefault()) : DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ULocale.getDefault())));
        try {
            exampleDate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-01-02 15:10:12");
        }
        catch (ParseException parseException) {
            exampleDate = new Date();
        }
        String strDate = dateTimeFormat.format(exampleDate);
        this.dateFormatCustomField.setText(strDate);
    }

    protected void createConsultChangeSets(Group consultChangeSetsGroup) {
        Listener changeSetsSelectionListener = new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamPreferencesPage.this.consultCSAlwaysButton.getSelection()) {
                    SVNTeamPreferencesPage.this.consultChangeSets = "always";
                } else if (SVNTeamPreferencesPage.this.consultCSNeverButton.getSelection()) {
                    SVNTeamPreferencesPage.this.consultChangeSets = "never";
                } else if (SVNTeamPreferencesPage.this.consultCSPromptButton.getSelection()) {
                    SVNTeamPreferencesPage.this.consultChangeSets = "prompt";
                }
            }
        };
        consultChangeSetsGroup.setText(SVNUIMessages.MainPreferencePage_consultChangeSetsGroupName);
        GridLayout layout = (GridLayout)consultChangeSetsGroup.getLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 40;
        GridData data = (GridData)consultChangeSetsGroup.getLayoutData();
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = false;
        this.consultCSAlwaysButton = new Button((Composite)consultChangeSetsGroup, 16);
        data = new GridData();
        this.consultCSAlwaysButton.setLayoutData((Object)data);
        this.consultCSAlwaysButton.setText(SVNUIMessages.MainPreferencePage_consultChangeSetsAlways);
        this.consultCSAlwaysButton.addListener(13, changeSetsSelectionListener);
        this.consultCSNeverButton = new Button((Composite)consultChangeSetsGroup, 16);
        data = new GridData();
        this.consultCSNeverButton.setLayoutData((Object)data);
        this.consultCSNeverButton.setText(SVNUIMessages.MainPreferencePage_consultChangeSetsNever);
        this.consultCSNeverButton.addListener(13, changeSetsSelectionListener);
        this.consultCSPromptButton = new Button((Composite)consultChangeSetsGroup, 16);
        data = new GridData();
        this.consultCSPromptButton.setLayoutData((Object)data);
        this.consultCSPromptButton.setText(SVNUIMessages.MainPreferencePage_consultChangeSetsPrompt);
        this.consultCSPromptButton.addListener(13, changeSetsSelectionListener);
    }

    protected Control createRepositorySettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 6;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_structureGroupName);
        Label label = new Label((Composite)group, 0);
        data = new GridData();
        data.horizontalSpan = 6;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_repositoryPrompt);
        label = new Label((Composite)group, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = SVNUIMessages.MainPreferencePage_repositoryHeadName;
        label.setText(labelText);
        this.headField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.headField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.headField, verifier);
        this.headField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.head = SVNTeamPreferencesPage.this.headField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNUIMessages.MainPreferencePage_repositoryBranchesName;
        label.setText(labelText);
        this.branchesField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.branchesField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.branchesField, verifier);
        this.branchesField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.branches = SVNTeamPreferencesPage.this.branchesField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNUIMessages.MainPreferencePage_repositoryTagsName;
        label.setText(labelText);
        this.tagsField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.tagsField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.tagsField, verifier);
        this.tagsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.tags = SVNTeamPreferencesPage.this.tagsField.getText();
            }
        });
        this.showExternalsButton = new Button((Composite)group, 32);
        data = new GridData(768);
        data.horizontalSpan = 6;
        this.showExternalsButton.setLayoutData((Object)data);
        this.showExternalsButton.setText(SVNUIMessages.MainPreferencePage_showExternals);
        this.showExternalsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showExternals = ((Button)e.widget).getSelection();
            }
        });
        group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_checkoutGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_checkoutPrompt);
        this.checkoutUsingDotProjectNameButton = new Button((Composite)group, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.checkoutUsingDotProjectNameButton.setLayoutData((Object)data);
        this.checkoutUsingDotProjectNameButton.setText(SVNUIMessages.MainPreferencePage_checkoutUsingDotProjectName);
        this.checkoutUsingDotProjectNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.checkoutUsingDotProjectName = SVNTeamPreferencesPage.this.checkoutUsingDotProjectNameButton.getSelection();
            }
        });
        this.checkoutRespectProjectStructureButton = new Button((Composite)group, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.checkoutRespectProjectStructureButton.setLayoutData((Object)data);
        this.checkoutRespectProjectStructureButton.setText(SVNUIMessages.MainPreferencePage_checkoutRespectProjectStructure);
        this.checkoutRespectProjectStructureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.checkoutRespectProjectStructure = SVNTeamPreferencesPage.this.checkoutRespectProjectStructureButton.getSelection();
            }
        });
        this.useDefaultLocationButton = new Button((Composite)group, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.useDefaultLocationButton.setLayoutData((Object)data);
        this.useDefaultLocationButton.setSelection(true);
        this.useDefaultLocationButton.setText(SVNUIMessages.ProjectLocationSelectionPage_UseDefaultLocation);
        this.useDefaultLocationButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPreferencesPage.this.checkoutUseDefaultLocation = SVNTeamPreferencesPage.this.useDefaultLocationButton.getSelection();
                SVNTeamPreferencesPage.this.locationField.setEnabled(!SVNTeamPreferencesPage.this.checkoutUseDefaultLocation);
                SVNTeamPreferencesPage.this.browse.setEnabled(!SVNTeamPreferencesPage.this.checkoutUseDefaultLocation);
                SVNTeamPreferencesPage.this.validateContent();
            }
        });
        this.locationField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.widthHint = 300;
        this.locationField.setLayoutData((Object)data);
        this.locationField.setEnabled(false);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(SVNUIMessages.ProjectLocationSelectionPage_Location_Verifier));
        verifier.add(new ExistingResourceVerifier(SVNUIMessages.ProjectLocationSelectionPage_Location_Verifier, false));
        this.attachTo((Control)this.locationField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return !SVNTeamPreferencesPage.this.useDefaultLocationButton.getSelection();
            }
        });
        this.locationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.checkoutSpecifiedLocation = SVNTeamPreferencesPage.this.locationField.getText();
            }
        });
        this.browse = new Button((Composite)group, 8);
        this.browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.setEnabled(false);
        this.browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(SVNTeamPreferencesPage.this.getShell());
                fileDialog.setFilterPath(SVNTeamPreferencesPage.this.locationField.getText());
                String res = fileDialog.open();
                if (res != null) {
                    SVNTeamPreferencesPage.this.locationField.setText(res);
                }
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNUIMessages.MainPreferencePage_branchTagGroupName);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_branchTagPrompt);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.branchTagConsiderStructure = SVNTeamPreferencesPage.this.branchTagConsiderStructureButton.getSelection();
            }
        };
        this.branchTagConsiderStructureButton = new Button((Composite)group, 16);
        this.branchTagConsiderStructureButton.setLayoutData((Object)new GridData());
        this.branchTagConsiderStructureButton.setText(SVNUIMessages.MainPreferencePage_branchTagConsiderStructureLabel);
        this.branchTagConsiderStructureButton.addSelectionListener((SelectionListener)listener);
        this.branchTagManualUrlEditButton = new Button((Composite)group, 16);
        this.branchTagManualUrlEditButton.setLayoutData((Object)new GridData());
        this.branchTagManualUrlEditButton.setText(SVNUIMessages.MainPreferencePage_branchTagManualLabel);
        this.branchTagManualUrlEditButton.addSelectionListener((SelectionListener)listener);
        label = new Label((Composite)group, 258);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        this.forceExternalsFreezeButton = new Button((Composite)group, 32);
        data = new GridData(768);
        this.forceExternalsFreezeButton.setLayoutData((Object)data);
        this.forceExternalsFreezeButton.setText(SVNUIMessages.MainPreferencePage_forceFreezeExternals);
        this.forceExternalsFreezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.forceExternalsFreeze = ((Button)e.widget).getSelection();
            }
        });
        return composite;
    }

    protected Control createErrorReportingSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.MainPreferencePage_mailReporterPrompt);
        this.mailReporterEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterEnabledButton.setLayoutData((Object)data);
        this.mailReporterEnabledButton.setText(SVNUIMessages.MainPreferencePage_mailReporterEnabledName);
        this.mailReporterEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterEnabled = SVNTeamPreferencesPage.this.mailReporterEnabledButton.getSelection();
            }
        });
        this.mailReporterErrorsEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterErrorsEnabledButton.setLayoutData((Object)data);
        this.mailReporterErrorsEnabledButton.setText(SVNUIMessages.MainPreferencePage_mailReporterErrorsEnabledName);
        this.mailReporterErrorsEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterErrorsEnabled = SVNTeamPreferencesPage.this.mailReporterErrorsEnabledButton.getSelection();
            }
        });
        return composite;
    }
}

