/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.rangeslider.finder.widgets;

import org.eclipse.nebula.widgets.opal.rangeslider.RangeSlider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=RangeSlider.class, preferredName="rangeslider", referenceBy={ReferenceBy.LABEL, ReferenceBy.MNEMONIC})
public class SWTBotRangeSlider
extends AbstractSWTBotControl<RangeSlider> {
    public SWTBotRangeSlider(RangeSlider w) throws WidgetNotFoundException {
        super((Control)w);
    }

    public SWTBotRangeSlider(RangeSlider w, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)w, description);
    }

    public void setLowerValue(final int value) {
        Assert.isLegal((value >= 0 ? 1 : 0) != 0, (Object)"The lower value is not valid");
        this.waitForEnabled();
        Point previousPoint = this.getXYFromValue(this.getLowerValue());
        this.sendEventsOnPrevious(previousPoint);
        Point newPoint = this.getXYFromValue(value);
        this.sendEventsOnNew(newPoint);
        this.syncExec(new VoidResult(){

            public void run() {
                SWTBotRangeSlider.this.log.debug("Selecting lower value {}", (Object)this);
                ((RangeSlider)SWTBotRangeSlider.this.widget).setLowerValue(value);
            }
        });
    }

    private void sendEventsOnPrevious(Point p) {
        this.notify(6, this.createMouseEvent(0, 0, 0));
        this.notify(26, super.createEvent());
        this.notify(15, super.createEvent());
        this.notify(3, this.createMouseEvent(p.x, p.y, 1, 0, 1));
        this.notify(4, this.createMouseEvent(p.x, p.y, 1, 524288, 1));
    }

    private void sendEventsOnNew(Point p) {
        this.notify(3, this.createMouseEvent(p.x, p.y, 1, 0, 1));
        this.notify(4, this.createMouseEvent(p.x, p.y, 1, 524288, 1));
        this.notify(3, this.createMouseEvent(p.x, p.y, 1, 0, 2));
        this.notify(8, this.createMouseEvent(p.x, p.y, 1, 0, 2));
        this.notify(4, this.createMouseEvent(p.x, p.y, 1, 524288, 2));
    }

    public void setUpperValue(final int value) {
        Assert.isLegal((value >= 0 ? 1 : 0) != 0, (Object)"The upper value is not valid");
        this.waitForEnabled();
        Point previousPoint = this.getXYFromValue(this.getUpperValue());
        this.sendEventsOnPrevious(previousPoint);
        Point newPoint = this.getXYFromValue(value);
        this.sendEventsOnNew(newPoint);
        this.syncExec(new VoidResult(){

            public void run() {
                SWTBotRangeSlider.this.log.debug("Selecting upper value {}", (Object)this);
                ((RangeSlider)SWTBotRangeSlider.this.widget).setUpperValue(value);
            }
        });
    }

    public void setSelection(int lowerValue, int upperValue) {
        boolean isUpperChange;
        Assert.isTrue((lowerValue <= upperValue ? 1 : 0) != 0, (Object)"The lower value must be less than or equal to the upper value");
        this.waitForEnabled();
        int originalLower = this.getLowerSelection();
        int originalUpper = this.getUpperSelection();
        boolean isLowerChange = originalLower != lowerValue;
        boolean bl = isUpperChange = originalUpper != upperValue;
        if (isLowerChange) {
            this.setLowerValue(lowerValue);
        }
        if (isUpperChange) {
            this.setUpperValue(upperValue);
        }
    }

    protected Rectangle getClientArea() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                if (((RangeSlider)SWTBotRangeSlider.this.widget).isDisposed()) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return ((RangeSlider)SWTBotRangeSlider.this.widget).getClientArea();
            }
        });
    }

    public int getLowerValue() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((RangeSlider)SWTBotRangeSlider.this.widget).getLowerValue();
            }
        });
    }

    public int getUpperValue() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((RangeSlider)SWTBotRangeSlider.this.widget).getUpperValue();
            }
        });
    }

    public int getLowerSelection() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((RangeSlider)SWTBotRangeSlider.this.widget).getSelection()[0];
            }
        });
    }

    public int getUpperSelection() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((RangeSlider)SWTBotRangeSlider.this.widget).getSelection()[1];
            }
        });
    }

    private Point getXYFromValue(final int value) {
        return (Point)this.syncExec((Result)new Result<Point>(){

            public Point run() {
                Rectangle rect = SWTBotRangeSlider.this.getClientArea();
                int min = ((RangeSlider)SWTBotRangeSlider.this.widget).getMinimum();
                int max = ((RangeSlider)SWTBotRangeSlider.this.widget).getMaximum();
                int x = 0;
                int y = 0;
                if ((((RangeSlider)SWTBotRangeSlider.this.widget).getStyle() & 0x100) != 0) {
                    x = (int)((double)(value * (rect.width - 20) / (max - min)) + 9.0);
                    y = rect.height / 2;
                } else if ((((RangeSlider)SWTBotRangeSlider.this.widget).getStyle() & 0x200) != 0) {
                    y = (int)((double)(value * (rect.height - 20) / (max - min)) + 9.0);
                    x = rect.width / 2;
                }
                return new Point(x, y);
            }
        });
    }
}

