/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import jdk.test.whitebox.WhiteBox;

public class ClassUnloadCommon {
    private static volatile Object dummy = null;

    public static void failIf(boolean value, String msg) {
        if (value) {
            throw new TestFailure("Test failed: " + msg);
        }
    }

    private static void allocateMemory(int kilobytes) {
        ArrayList<byte[]> l;
        dummy = l = new ArrayList<byte[]>();
        for (int i = kilobytes; i > 0; --i) {
            l.add(new byte[1024]);
        }
        l = null;
        dummy = null;
    }

    public static void triggerUnloading() {
        WhiteBox wb = WhiteBox.getWhiteBox();
        wb.fullGC();
    }

    public static Set<String> triggerUnloading(List<String> classNames) {
        WhiteBox wb = WhiteBox.getWhiteBox();
        HashSet<String> aliveClasses = new HashSet<String>(classNames);
        for (int attempt = 0; !aliveClasses.isEmpty() && attempt < 20; ++attempt) {
            ClassUnloadCommon.triggerUnloading();
            for (String className : classNames) {
                if (!aliveClasses.contains(className)) continue;
                if (wb.isClassAlive(className)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                aliveClasses.remove(className);
            }
        }
        return aliveClasses;
    }

    public static ClassLoader newClassLoader() {
        String cp = System.getProperty("test.class.path", ".");
        URL[] urls = (URL[])Stream.of(cp.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).map(ClassUnloadCommon::toURL).toArray(URL[]::new);
        return new URLClassLoader("ClassUnloadCommonClassLoader", urls, new ClassUnloadCommon().getClass().getClassLoader()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
                Object object = this.getClassLoadingLock(cn);
                synchronized (object) {
                    Class<?> c = this.findLoadedClass(cn);
                    if (c == null) {
                        try {
                            c = this.findClass(cn);
                        }
                        catch (ClassNotFoundException e) {
                            c = this.getParent().loadClass(cn);
                        }
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
        };
    }

    static URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getClassData(String name) {
        try {
            String tempName = name.replaceAll("\\.", "/");
            return ClassUnloadCommon.class.getClassLoader().getResourceAsStream(tempName + ".class").readAllBytes();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class TestFailure
    extends RuntimeException {
        TestFailure(String msg) {
            super(msg);
        }
    }
}

