/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.cosnaming;

import com.sun.corba.se.impl.logging.NamingSystemException;
import com.sun.corba.se.impl.naming.cosnaming.InterOperableNamingImpl;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.se.impl.naming.cosnaming.NamingUtils;
import com.sun.corba.se.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.se.spi.orb.ORB;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class NamingContextImpl
extends NamingContextExtPOA
implements NamingContextDataStore {
    protected POA nsPOA;
    private Logger readLogger;
    private Logger updateLogger;
    private Logger lifecycleLogger;
    private NamingSystemException wrapper;
    private static NamingSystemException staticWrapper = NamingSystemException.get("naming.update");
    private InterOperableNamingImpl insImpl;
    protected transient ORB orb;
    public static final boolean debug = false;

    public NamingContextImpl(ORB oRB, POA pOA) throws Exception {
        this.orb = oRB;
        this.wrapper = NamingSystemException.get(oRB, "naming.update");
        this.insImpl = new InterOperableNamingImpl();
        this.nsPOA = pOA;
        this.readLogger = oRB.getLogger("naming.read");
        this.updateLogger = oRB.getLogger("naming.update");
        this.lifecycleLogger = oRB.getLogger("naming.lifecycle");
    }

    @Override
    public POA getNSPOA() {
        return this.nsPOA;
    }

    @Override
    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (object == null) {
            this.updateLogger.warning("<<NAMING BIND>> unsuccessful because NULL Object cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doBind(namingContextImpl, nameComponentArray, object, false, BindingType.nobject);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
    }

    @Override
    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (namingContext == null) {
            this.updateLogger.warning("<<NAMING BIND>><<FAILURE>> NULL Context cannot be Bound ");
            throw new BAD_PARAM("Naming Context should not be null ");
        }
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doBind(namingContextImpl, nameComponentArray, namingContext, false, BindingType.ncontext);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
    }

    @Override
    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (object == null) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>> NULL Object cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        try {
            NamingContextImpl namingContextImpl = this;
            NamingContextImpl.doBind(namingContextImpl, nameComponentArray, object, true, BindingType.nobject);
        }
        catch (AlreadyBound alreadyBound) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>>" + NamingUtils.getDirectoryStructuredName(nameComponentArray) + " is already bound to a Naming Context");
            throw this.wrapper.namingCtxRebindAlreadyBound(alreadyBound);
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING REBIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
    }

    @Override
    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        if (namingContext == null) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>> NULL Context cannot be Bound ");
            throw this.wrapper.objectIsNull();
        }
        try {
            NamingContextImpl namingContextImpl = this;
            NamingContextImpl.doBind(namingContextImpl, nameComponentArray, namingContext, true, BindingType.ncontext);
        }
        catch (AlreadyBound alreadyBound) {
            this.updateLogger.warning("<<NAMING REBIND>><<FAILURE>>" + NamingUtils.getDirectoryStructuredName(nameComponentArray) + " is already bound to a CORBA Object");
            throw this.wrapper.namingCtxRebindctxAlreadyBound(alreadyBound);
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING REBIND>><<SUCCESS>> Name = " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
    }

    @Override
    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl namingContextImpl = this;
        Object object = NamingContextImpl.doResolve(namingContextImpl, nameComponentArray);
        if (object != null) {
            if (this.readLogger.isLoggable(Level.FINE)) {
                this.readLogger.fine("<<NAMING RESOLVE>><<SUCCESS>> Name: " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
            }
        } else {
            this.readLogger.warning("<<NAMING RESOLVE>><<FAILURE>> Name: " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
        return object;
    }

    @Override
    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doUnbind(namingContextImpl, nameComponentArray);
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING UNBIND>><<SUCCESS>> Name: " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        NamingContextImpl namingContextImpl;
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            namingContextImpl.List(n, bindingListHolder, bindingIteratorHolder);
        }
        if (this.readLogger.isLoggable(Level.FINE) && bindingListHolder.value != null) {
            this.readLogger.fine("<<NAMING LIST>><<SUCCESS>>list(" + n + ") -> bindings[" + bindingListHolder.value.length + "] + iterator: " + bindingIteratorHolder.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NamingContext new_context() {
        NamingContextImpl namingContextImpl;
        this.lifecycleLogger.fine("Creating New Naming Context ");
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            NamingContext namingContext = namingContextImpl.NewContext();
            if (namingContext != null) {
                this.lifecycleLogger.fine("<<LIFECYCLE CREATE>><<SUCCESS>>");
            } else {
                this.lifecycleLogger.severe("<<LIFECYCLE CREATE>><<FAILURE>>");
            }
            return namingContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext namingContext = null;
        NamingContext namingContext2 = null;
        try {
            namingContext = this.new_context();
            this.bind_context(nameComponentArray, namingContext);
            namingContext2 = namingContext;
            namingContext = null;
        }
        finally {
            try {
                if (namingContext != null) {
                    namingContext.destroy();
                }
            }
            catch (NotEmpty notEmpty) {}
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>>New Context Bound To " + NamingUtils.getDirectoryStructuredName(nameComponentArray));
        }
        return namingContext2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws NotEmpty {
        NamingContextImpl namingContextImpl;
        this.lifecycleLogger.fine("Destroying Naming Context ");
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            if (!namingContextImpl.IsEmpty()) {
                this.lifecycleLogger.warning("<<LIFECYCLE DESTROY>><<FAILURE>> NamingContext children are not destroyed still..");
                throw new NotEmpty();
            }
            namingContextImpl.Destroy();
            this.lifecycleLogger.fine("<<LIFECYCLE DESTROY>><<SUCCESS>>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray, Object object, boolean bl, BindingType bindingType) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0 && nameComponentArray[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
                if (bl) {
                    Object object2 = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
                    if (object2 != null) {
                        if (bindingTypeHolder.value.value() == BindingType.nobject.value()) {
                            if (bindingType.value() == BindingType.ncontext.value()) {
                                throw new NotFound(NotFoundReason.not_context, nameComponentArray);
                            }
                        } else if (bindingType.value() == BindingType.nobject.value()) {
                            throw new NotFound(NotFoundReason.not_object, nameComponentArray);
                        }
                        namingContextDataStore.Unbind(nameComponentArray[0]);
                    }
                } else if (namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder) != null) {
                    throw new AlreadyBound();
                }
                namingContextDataStore.Bind(nameComponentArray[0], object, bindingType);
            }
        } else {
            NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
            switch (bindingType.value()) {
                case 0: {
                    if (bl) {
                        namingContext.rebind(nameComponentArray2, object);
                        break;
                    }
                    namingContext.bind(nameComponentArray2, object);
                    break;
                }
                case 1: {
                    NamingContext namingContext2 = (NamingContext)object;
                    if (bl) {
                        namingContext.rebind_context(nameComponentArray2, namingContext2);
                        break;
                    }
                    namingContext.bind_context(nameComponentArray2, namingContext2);
                    break;
                }
                default: {
                    throw staticWrapper.namingCtxBadBindingtype();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doResolve(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return object;
        }
        if (nameComponentArray[1].id.length() == 0 && nameComponentArray[1].kind.length() == 0) {
            throw new InvalidName();
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        try {
            Servant servant = namingContextDataStore.getNSPOA().reference_to_servant(namingContext);
            return NamingContextImpl.doResolve((NamingContextDataStore)((java.lang.Object)servant), nameComponentArray2);
        }
        catch (Exception exception) {
            return namingContext.resolve(nameComponentArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnbind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0 && nameComponentArray[0].kind.length() == 0) {
                throw new InvalidName();
            }
            Object object = null;
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Unbind(nameComponentArray[0]);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return;
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        namingContext.unbind(nameComponentArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        NamingContext namingContext = null;
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
        synchronized (namingContextDataStore2) {
            object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
        }
        if (bindingTypeHolder.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        try {
            namingContext = NamingContextHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        return namingContext;
    }

    @Override
    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        NamingContextImpl namingContextImpl = this;
        String string = this.insImpl.convertToString(nameComponentArray);
        if (string == null) {
            throw new InvalidName();
        }
        return string;
    }

    @Override
    public NameComponent[] to_name(String string) throws InvalidName {
        if (string == null || string.length() == 0) {
            throw new InvalidName();
        }
        NamingContextImpl namingContextImpl = this;
        NameComponent[] nameComponentArray = this.insImpl.convertToNameComponent(string);
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        for (int i = 0; i < nameComponentArray.length; ++i) {
            if (nameComponentArray[i].id != null && nameComponentArray[i].id.length() != 0 || nameComponentArray[i].kind != null && nameComponentArray[i].kind.length() != 0) continue;
            throw new InvalidName();
        }
        return nameComponentArray;
    }

    @Override
    public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
        if (string2 == null || string2.length() == 0) {
            throw new InvalidName();
        }
        if (string == null) {
            throw new InvalidAddress();
        }
        NamingContextImpl namingContextImpl = this;
        String string3 = null;
        string3 = this.insImpl.createURLBasedAddress(string, string2);
        try {
            INSURLHandler.getINSURLHandler().parseURL(string3);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new InvalidAddress();
        }
        return string3;
    }

    @Override
    public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        if (string == null || string.length() == 0) {
            throw new InvalidName();
        }
        NamingContextImpl namingContextImpl = this;
        NameComponent[] nameComponentArray = this.insImpl.convertToNameComponent(string);
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        object = this.resolve(nameComponentArray);
        return object;
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (nameComponentArray != null || nameComponentArray.length > 0) {
            for (int i = 0; i < nameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[").append(nameComponentArray[i].id).append(",").append(nameComponentArray[i].kind).append("]");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static void dprint(String string) {
        NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + string);
    }
}

