/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.DefaultLdapDnsProvider;
import com.sun.jndi.ldap.spi.LdapDnsProvider;
import com.sun.jndi.ldap.spi.LdapDnsProviderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.naming.NamingException;
import sun.security.util.SecurityConstants;

final class LdapDnsProviderService {
    private static volatile LdapDnsProviderService service;
    private static final Object LOCK;
    private final ServiceLoader<LdapDnsProvider> providers;

    private LdapDnsProviderService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            this.providers = ServiceLoader.load(LdapDnsProvider.class, ClassLoader.getSystemClassLoader());
        } else {
            PrivilegedAction<ServiceLoader> privilegedAction = () -> ServiceLoader.load(LdapDnsProvider.class, ClassLoader.getSystemClassLoader());
            this.providers = AccessController.doPrivileged(privilegedAction, null, new RuntimePermission("ldapDnsProvider"), SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LdapDnsProviderService getInstance() {
        if (service != null) {
            return service;
        }
        Object object = LOCK;
        synchronized (object) {
            if (service != null) {
                return service;
            }
            service = new LdapDnsProviderService();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapDnsProviderResult lookupEndpoints(String string, Hashtable<?, ?> hashtable) throws NamingException {
        LdapDnsProviderResult ldapDnsProviderResult2 = null;
        Hashtable hashtable2 = new Hashtable(hashtable);
        Object object = LOCK;
        synchronized (object) {
            Iterator<LdapDnsProvider> iterator = this.providers.iterator();
            while (ldapDnsProviderResult2 == null && iterator.hasNext()) {
                ldapDnsProviderResult2 = iterator.next().lookupEndpoints(string, hashtable2).filter(ldapDnsProviderResult -> !ldapDnsProviderResult.getEndpoints().isEmpty()).orElse(null);
            }
        }
        if (ldapDnsProviderResult2 == null) {
            return new DefaultLdapDnsProvider().lookupEndpoints(string, hashtable).orElse(new LdapDnsProviderResult("", Collections.emptyList()));
        }
        return ldapDnsProviderResult2;
    }

    static {
        LOCK = new int[0];
    }
}

