/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class WeakObjectPool<T, E extends Throwable> {
    private static final Integer MARKER_VALUE = Integer.MAX_VALUE;
    private final BlockingQueue<WeakReference<T>> available = new LinkedBlockingDeque<WeakReference<T>>();
    private final Map<T, Integer> onLoan = Collections.synchronizedMap(new WeakHashMap());

    protected WeakObjectPool() {
    }

    protected abstract T createObject() throws E;

    public T getObject() throws E {
        WeakReference weakReference;
        T t = null;
        while ((weakReference = (WeakReference)this.available.poll()) != null) {
            Object t2 = weakReference.get();
            t = t2;
            if (t2 == null) continue;
        }
        if (t == null) {
            t = this.createObject();
        }
        this.onLoan.put(t, MARKER_VALUE);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean repool(T t) {
        if (t != null && this.onLoan.containsKey(t)) {
            T t2 = t;
            synchronized (t2) {
                if (this.onLoan.remove(t) != null) {
                    return this.available.offer(new WeakReference<T>(t));
                }
            }
        }
        return false;
    }
}

