/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.MultipleGradientPaint;
import java.awt.geom.AffineTransform;
import sun.java2d.loops.SurfaceType;

public class XRUtils {
    public static final int None = 0;
    public static final byte PictOpClear = 0;
    public static final byte PictOpSrc = 1;
    public static final byte PictOpDst = 2;
    public static final byte PictOpOver = 3;
    public static final byte PictOpOverReverse = 4;
    public static final byte PictOpIn = 5;
    public static final byte PictOpInReverse = 6;
    public static final byte PictOpOut = 7;
    public static final byte PictOpOutReverse = 8;
    public static final byte PictOpAtop = 9;
    public static final byte PictOpAtopReverse = 10;
    public static final byte PictOpXor = 11;
    public static final byte PictOpAdd = 12;
    public static final byte PictOpSaturate = 13;
    public static final int RepeatNone = 0;
    public static final int RepeatNormal = 1;
    public static final int RepeatPad = 2;
    public static final int RepeatReflect = 3;
    public static final int FAST = 0;
    public static final int GOOD = 1;
    public static final int BEST = 2;
    public static final byte[] FAST_NAME = "fast".getBytes();
    public static final byte[] GOOD_NAME = "good".getBytes();
    public static final byte[] BEST_NAME = "best".getBytes();
    public static final int PictStandardARGB32 = 0;
    public static final int PictStandardRGB24 = 1;
    public static final int PictStandardA8 = 2;
    public static final int PictStandardA4 = 3;
    public static final int PictStandardA1 = 4;

    public static int ATransOpToXRQuality(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public static byte[] ATransOpToXRQualityName(int n) {
        switch (n) {
            case 1: {
                return FAST_NAME;
            }
            case 2: {
                return GOOD_NAME;
            }
            case 3: {
                return BEST_NAME;
            }
        }
        return null;
    }

    public static byte[] getFilterName(int n) {
        switch (n) {
            case 0: {
                return FAST_NAME;
            }
            case 1: {
                return GOOD_NAME;
            }
            case 2: {
                return BEST_NAME;
            }
        }
        return null;
    }

    public static int getPictureFormatForTransparency(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static SurfaceType getXRSurfaceTypeForTransparency(int n) {
        if (n == 1) {
            return SurfaceType.IntRgb;
        }
        return SurfaceType.IntArgbPre;
    }

    public static int getRepeatForCycleMethod(MultipleGradientPaint.CycleMethod cycleMethod) {
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.NO_CYCLE)) {
            return 2;
        }
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.REFLECT)) {
            return 3;
        }
        if (cycleMethod.equals((Object)MultipleGradientPaint.CycleMethod.REPEAT)) {
            return 1;
        }
        return 0;
    }

    public static int XDoubleToFixed(double d) {
        return (int)(d * 65536.0);
    }

    public static double XFixedToDouble(int n) {
        return (double)n / 65536.0;
    }

    public static int[] convertFloatsToFixed(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = XRUtils.XDoubleToFixed(fArray[i]);
        }
        return nArray;
    }

    public static long intToULong(int n) {
        if (n < 0) {
            return (long)n + 0x100000000L;
        }
        return n;
    }

    public static byte j2dAlphaCompToXR(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
        }
        throw new InternalError("No XRender equivalent available for requested java2d composition rule: " + n);
    }

    public static short clampToShort(int n) {
        return (short)(n > Short.MAX_VALUE ? Short.MAX_VALUE : (n < Short.MIN_VALUE ? Short.MIN_VALUE : n));
    }

    public static int clampToUShort(int n) {
        return n > 65535 ? 65535 : (n < 0 ? 0 : n);
    }

    public static boolean isTransformQuadrantRotated(AffineTransform affineTransform) {
        return (affineTransform.getType() & 0x30) == 0;
    }

    public static boolean isMaskEvaluated(byte by) {
        switch (by) {
            case 3: 
            case 4: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

