/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.ThreadPool;

public class SimpleAsynchronousFileChannelImpl
extends AsynchronousFileChannelImpl {
    private static final FileDispatcher nd = new FileDispatcherImpl();
    private final NativeThreadSet threads = new NativeThreadSet(2);

    SimpleAsynchronousFileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ExecutorService executorService) {
        super(fileDescriptor, bl, bl2, executorService);
    }

    public static AsynchronousFileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ThreadPool threadPool) {
        ExecutorService executorService = threadPool == null ? DefaultExecutorHolder.defaultExecutor : threadPool.executor();
        return new SimpleAsynchronousFileChannelImpl(fileDescriptor, bl, bl2, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FileDescriptor fileDescriptor = this.fdObj;
        synchronized (fileDescriptor) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.invalidateAllLocks();
        this.threads.signalAndWait();
        this.closeLock.writeLock().lock();
        this.closeLock.writeLock().unlock();
        nd.close(this.fdObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        int n = this.threads.add();
        try {
            long l;
            long l2 = 0L;
            try {
                this.begin();
                while ((l2 = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                l = l2;
                this.end(l2 >= 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 >= 0L);
                throw throwable;
            }
            return l;
        }
        finally {
            this.threads.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        int n = this.threads.add();
        try {
            SimpleAsynchronousFileChannelImpl simpleAsynchronousFileChannelImpl;
            long l2 = 0L;
            try {
                this.begin();
                while ((l2 = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                if (l < l2 && this.isOpen()) {
                    while ((l2 = (long)nd.truncate(this.fdObj, l)) == -3L && this.isOpen()) {
                    }
                }
                simpleAsynchronousFileChannelImpl = this;
                this.end(l2 > 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 > 0L);
                throw throwable;
            }
            return simpleAsynchronousFileChannelImpl;
        }
        finally {
            this.threads.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean bl) throws IOException {
        int n = this.threads.add();
        try {
            int n2 = 0;
            try {
                this.begin();
                while ((n2 = nd.force(this.fdObj, bl)) == -3 && this.isOpen()) {
                }
                this.end(n2 >= 0);
            }
            catch (Throwable throwable) {
                this.end(n2 >= 0);
                throw throwable;
            }
        }
        finally {
            this.threads.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<FileLock> implLock(final long l, final long l2, final boolean bl, final A a, final CompletionHandler<FileLock, ? super A> completionHandler) {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        final FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invokeIndirectly(completionHandler, a, null, closedChannelException, this.executor);
            return null;
        }
        final PendingFuture pendingFuture = completionHandler == null ? new PendingFuture(this) : null;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable throwable = null;
                int n = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    try {
                        int n2;
                        SimpleAsynchronousFileChannelImpl.this.begin();
                        while ((n2 = nd.lock(SimpleAsynchronousFileChannelImpl.this.fdObj, true, l, l2, bl)) == 2 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        }
                        if (n2 != 0 || !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                            throw new AsynchronousCloseException();
                        }
                    }
                    catch (IOException iOException) {
                        AsynchronousCloseException asynchronousCloseException;
                        SimpleAsynchronousFileChannelImpl.this.removeFromFileLockTable(fileLockImpl);
                        if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                            asynchronousCloseException = new AsynchronousCloseException();
                        }
                        throwable = asynchronousCloseException;
                    }
                    finally {
                        SimpleAsynchronousFileChannelImpl.this.end();
                    }
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(n);
                }
                if (completionHandler == null) {
                    pendingFuture.setResult(fileLockImpl, throwable);
                } else {
                    Invoker.invokeUnchecked(completionHandler, a, fileLockImpl, throwable);
                }
            }
        };
        boolean bl2 = false;
        try {
            this.executor.execute(runnable);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.removeFromFileLockTable(fileLockImpl);
            }
        }
        return pendingFuture;
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            throw new ClosedChannelException();
        }
        int n = this.threads.add();
        boolean bl2 = false;
        try {
            int n2;
            this.begin();
            while ((n2 = nd.lock(this.fdObj, false, l, l2, bl)) == 2 && this.isOpen()) {
            }
            if (n2 == 0 && this.isOpen()) {
                bl2 = true;
                FileLockImpl fileLockImpl2 = fileLockImpl;
                return fileLockImpl2;
            }
            if (n2 == -1) {
                FileLock fileLock = null;
                return fileLock;
            }
            if (n2 == 2) {
                throw new AsynchronousCloseException();
            }
            throw new AssertionError();
        }
        finally {
            if (!bl2) {
                this.removeFromFileLockTable(fileLockImpl);
            }
            this.end();
            this.threads.remove(n);
        }
    }

    @Override
    protected void implRelease(FileLockImpl fileLockImpl) throws IOException {
        nd.release(this.fdObj, fileLockImpl.position(), fileLockImpl.size());
    }

    @Override
    <A> Future<Integer> implRead(final ByteBuffer byteBuffer, final long l, final A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.reading) {
            throw new NonReadableChannelException();
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (!this.isOpen() || byteBuffer.remaining() == 0) {
            ClosedChannelException closedChannelException;
            ClosedChannelException closedChannelException2 = closedChannelException = this.isOpen() ? null : new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withResult(0, closedChannelException);
            }
            Invoker.invokeIndirectly(completionHandler, a, 0, closedChannelException, this.executor);
            return null;
        }
        final PendingFuture pendingFuture = completionHandler == null ? new PendingFuture(this) : null;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n = 0;
                Throwable throwable = null;
                int n2 = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n = IOUtil.read(SimpleAsynchronousFileChannelImpl.this.fdObj, byteBuffer, l, nd)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                }
                catch (IOException iOException) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    throwable = asynchronousCloseException;
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(n2);
                }
                if (completionHandler == null) {
                    pendingFuture.setResult(n, throwable);
                } else {
                    Invoker.invokeUnchecked(completionHandler, a, n, throwable);
                }
            }
        };
        this.executor.execute(runnable);
        return pendingFuture;
    }

    @Override
    <A> Future<Integer> implWrite(final ByteBuffer byteBuffer, final long l, final A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        if (!this.isOpen() || byteBuffer.remaining() == 0) {
            ClosedChannelException closedChannelException;
            ClosedChannelException closedChannelException2 = closedChannelException = this.isOpen() ? null : new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withResult(0, closedChannelException);
            }
            Invoker.invokeIndirectly(completionHandler, a, 0, closedChannelException, this.executor);
            return null;
        }
        final PendingFuture pendingFuture = completionHandler == null ? new PendingFuture(this) : null;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n = 0;
                Throwable throwable = null;
                int n2 = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n = IOUtil.write(SimpleAsynchronousFileChannelImpl.this.fdObj, byteBuffer, l, nd)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                }
                catch (IOException iOException) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    throwable = asynchronousCloseException;
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(n2);
                }
                if (completionHandler == null) {
                    pendingFuture.setResult(n, throwable);
                } else {
                    Invoker.invokeUnchecked(completionHandler, a, n, throwable);
                }
            }
        };
        this.executor.execute(runnable);
        return pendingFuture;
    }

    private static class DefaultExecutorHolder {
        static final ExecutorService defaultExecutor = ThreadPool.createDefault().executor();

        private DefaultExecutorHolder() {
        }
    }
}

