/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.RemappingMethodAdapter;
import jdk.internal.org.objectweb.asm.commons.SimpleRemapper;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.instrument.JITypeMapping;

@Deprecated
final class JIMethodMergeAdapter
extends ClassVisitor {
    private final ClassNode cn;
    private final List<Method> methodFilter;
    private final Map<String, String> typeMap;

    public JIMethodMergeAdapter(ClassVisitor classVisitor, ClassNode classNode, List<Method> list, JITypeMapping[] jITypeMappingArray) {
        super(327680, classVisitor);
        this.cn = classNode;
        this.methodFilter = list;
        this.typeMap = new HashMap<String, String>();
        for (JITypeMapping jITypeMapping : jITypeMappingArray) {
            this.typeMap.put(jITypeMapping.from().replace('.', '/'), jITypeMapping.to().replace('.', '/'));
        }
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super.visit(n, n2, string, string2, string3, stringArray);
        this.typeMap.put(this.cn.name, string);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (this.methodInFilter(string, string2)) {
            Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.DEBUG, "Deleting " + string + string2);
            return null;
        }
        return super.visitMethod(n, string, string2, string3, stringArray);
    }

    @Override
    public void visitEnd() {
        SimpleRemapper simpleRemapper = new SimpleRemapper(this.typeMap);
        for (MethodNode methodNode : this.cn.methods) {
            if (!this.methodInFilter(methodNode.name, methodNode.desc)) continue;
            Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.DEBUG, "Copying method: " + methodNode.name + methodNode.desc);
            Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.DEBUG, "   with mapper: " + this.typeMap);
            String[] stringArray = new String[methodNode.exceptions.size()];
            methodNode.exceptions.toArray(stringArray);
            MethodVisitor methodVisitor = this.cv.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, stringArray);
            methodNode.instructions.resetLabels();
            methodNode.accept(new RemappingMethodAdapter(methodNode.access, methodNode.desc, methodVisitor, simpleRemapper));
        }
        super.visitEnd();
    }

    private boolean methodInFilter(String string, String string2) {
        for (Method method : this.methodFilter) {
            if (!method.getName().equals(string) || !Type.getMethodDescriptor(method).equals(string2)) continue;
            return true;
        }
        return false;
    }
}

