/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.java_lang_Class;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class InstanceMirrorKlass
extends InstanceKlass {
    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("InstanceMirrorKlass");
    }

    public InstanceMirrorKlass(Address addr) {
        super(addr);
    }

    @Override
    public long getObjectSize(Oop o) {
        return java_lang_Class.getOopSize(o) * VM.getVM().getAddressSize();
    }

    @Override
    public void iterateNonStaticFields(OopVisitor visitor, Oop obj) {
        super.iterateNonStaticFields(visitor, obj);
        Klass klass = java_lang_Class.asKlass(obj);
        if (klass instanceof InstanceKlass) {
            ((InstanceKlass)klass).iterateStaticFields(visitor);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                InstanceMirrorKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

