/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CompactibleSpace;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class HeapRegion
extends CompactibleSpace {
    private static CIntegerField grainBytesField;
    private static AddressField topField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("HeapRegion");
        grainBytesField = type.getCIntegerField("GrainBytes");
        topField = type.getAddressField("_top");
    }

    public static long grainBytes() {
        return grainBytesField.getValue();
    }

    public HeapRegion(Address addr) {
        super(addr);
    }

    public Address top() {
        return topField.getValue(this.addr);
    }

    @Override
    public List getLiveRegions() {
        ArrayList<MemRegion> res = new ArrayList<MemRegion>();
        res.add(new MemRegion(this.bottom(), this.top()));
        return res;
    }

    @Override
    public long used() {
        return this.top().minus(this.bottom());
    }

    @Override
    public long free() {
        return this.end().minus(this.top());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                HeapRegion.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

