/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeJmp;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeGoto
extends BytecodeJmp {
    BytecodeGoto(Method method, int bci) {
        super(method, bci);
    }

    @Override
    public int getTargetBCI() {
        return this.bci() + this.javaShortAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check goto");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 167;
    }

    public static BytecodeGoto at(Method method, int bci) {
        BytecodeGoto b = new BytecodeGoto(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeGoto atCheck(Method method, int bci) {
        BytecodeGoto b = new BytecodeGoto(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeGoto at(BytecodeStream bcs) {
        return new BytecodeGoto(bcs.method(), bcs.bci());
    }
}

