/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.InterfaceTypeImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.oops.InstanceKlass;

public class ClassTypeImpl
extends ReferenceTypeImpl
implements ClassType {
    private SoftReference interfacesCache = null;
    private SoftReference allInterfacesCache = null;
    private SoftReference subclassesCache = null;

    protected ClassTypeImpl(VirtualMachine aVm, InstanceKlass aRef) {
        super(aVm, aRef);
    }

    @Override
    public ClassType superclass() {
        InstanceKlass kk = (InstanceKlass)this.ref().getSuper();
        if (kk == null) {
            return null;
        }
        return (ClassType)((Object)this.vm.referenceType(kk));
    }

    public List interfaces() {
        List interfaces;
        List list = interfaces = this.interfacesCache != null ? (List)this.interfacesCache.get() : null;
        if (interfaces == null) {
            this.checkPrepared();
            interfaces = Collections.unmodifiableList(this.getInterfaces());
            this.interfacesCache = new SoftReference(interfaces);
        }
        return interfaces;
    }

    void addInterfaces(List list) {
        List immediate = this.interfaces();
        HashSet hashList = new HashSet(list);
        hashList.addAll(immediate);
        list.clear();
        list.addAll(hashList);
        for (InterfaceTypeImpl interfaze : immediate) {
            interfaze.addSuperinterfaces(list);
        }
        ClassTypeImpl superclass = (ClassTypeImpl)this.superclass();
        if (superclass != null) {
            superclass.addInterfaces(list);
        }
    }

    public List allInterfaces() {
        List allinterfaces;
        ArrayList arrayList = allinterfaces = this.allInterfacesCache != null ? (ArrayList)this.allInterfacesCache.get() : null;
        if (allinterfaces == null) {
            this.checkPrepared();
            allinterfaces = new ArrayList();
            this.addInterfaces(allinterfaces);
            allinterfaces = Collections.unmodifiableList(allinterfaces);
            this.allInterfacesCache = new SoftReference(allinterfaces);
        }
        return allinterfaces;
    }

    public List subclasses() {
        List<ReferenceType> subclasses;
        List list = subclasses = this.subclassesCache != null ? (ArrayList)this.subclassesCache.get() : null;
        if (subclasses == null) {
            List all = this.vm.allClasses();
            subclasses = new ArrayList(0);
            for (ReferenceType refType : all) {
                ClassType clazz;
                ClassType superclass;
                if (!(refType instanceof ClassType) || (superclass = (clazz = (ClassType)refType).superclass()) == null || !superclass.equals(this)) continue;
                subclasses.add(refType);
            }
            subclasses = Collections.unmodifiableList(subclasses);
            this.subclassesCache = new SoftReference(subclasses);
        }
        return subclasses;
    }

    @Override
    public Method concreteMethodByName(String name, String signature) {
        this.checkPrepared();
        List methods = this.visibleMethods();
        Method method = null;
        for (Method candidate : methods) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature) || candidate.isAbstract()) continue;
            method = candidate;
            break;
        }
        return method;
    }

    @Override
    List getAllMethods() {
        ArrayList<Method> list = new ArrayList<Method>(this.methods());
        for (ClassType clazz = this.superclass(); clazz != null; clazz = clazz.superclass()) {
            list.addAll(clazz.methods());
        }
        for (InterfaceType interfaze : this.allInterfaces()) {
            list.addAll(interfaze.methods());
        }
        return list;
    }

    @Override
    List inheritedTypes() {
        ArrayList<ClassType> inherited = new ArrayList<ClassType>(this.interfaces());
        if (this.superclass() != null) {
            inherited.add(0, this.superclass());
        }
        return inherited;
    }

    @Override
    public boolean isEnum() {
        ClassTypeImpl superclass = (ClassTypeImpl)this.superclass();
        if (superclass != null) {
            return superclass.typeNameAsSymbol().equals(this.vm.javaLangEnum());
        }
        return false;
    }

    @Override
    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ClassType.setValue(...)");
    }

    public Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List arguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.vm.throwNotReadOnlyException("ClassType.invokeMethod(...)");
        return null;
    }

    public ObjectReference newInstance(ThreadReference threadIntf, Method methodIntf, List arguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.vm.throwNotReadOnlyException("ClassType.newInstance(...)");
        return null;
    }

    @Override
    void addVisibleMethods(Map methodMap) {
        for (InterfaceTypeImpl interfaze : this.interfaces()) {
            interfaze.addVisibleMethods(methodMap);
        }
        ClassTypeImpl clazz = (ClassTypeImpl)this.superclass();
        if (clazz != null) {
            clazz.addVisibleMethods(methodMap);
        }
        this.addToMethodMap(methodMap, this.methods());
    }

    @Override
    boolean isAssignableTo(ReferenceType type) {
        ClassTypeImpl superclazz = (ClassTypeImpl)this.superclass();
        if (this.equals(type)) {
            return true;
        }
        if (superclazz != null && superclazz.isAssignableTo(type)) {
            return true;
        }
        List interfaces = this.interfaces();
        for (InterfaceTypeImpl interfaze : interfaces) {
            if (!interfaze.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "class " + this.name() + "(" + this.loaderString() + ")";
    }
}

