/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.DictionaryEntry;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.TwoOopHashtable;

public class Dictionary
extends TwoOopHashtable {
    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Dictionary");
    }

    public Dictionary(Address addr) {
        super(addr);
    }

    @Override
    protected Class getHashtableEntryClass() {
        return DictionaryEntry.class;
    }

    public void classesDo(SystemDictionary.ClassVisitor v) {
        ObjectHeap heap = VM.getVM().getObjectHeap();
        int tblSize = this.tableSize();
        for (int index = 0; index < tblSize; ++index) {
            for (DictionaryEntry probe = (DictionaryEntry)this.bucket(index); probe != null; probe = (DictionaryEntry)probe.next()) {
                Klass k = probe.klass();
                if (!heap.equal(probe.loader(), ((InstanceKlass)k).getClassLoader())) continue;
                v.visit(k);
            }
        }
    }

    public void classesDo(SystemDictionary.ClassAndLoaderVisitor v) {
        int tblSize = this.tableSize();
        for (int index = 0; index < tblSize; ++index) {
            for (DictionaryEntry probe = (DictionaryEntry)this.bucket(index); probe != null; probe = (DictionaryEntry)probe.next()) {
                Klass k = probe.klass();
                v.visit(k, probe.loader());
            }
        }
    }

    public Klass find(int index, long hash, Symbol className, Oop classLoader, Oop protectionDomain) {
        DictionaryEntry entry = this.getEntry(index, hash, className, classLoader);
        if (entry != null && entry.isValidProtectionDomain(protectionDomain)) {
            return entry.klass();
        }
        return null;
    }

    private DictionaryEntry getEntry(int index, long hash, Symbol className, Oop classLoader) {
        for (DictionaryEntry entry = (DictionaryEntry)this.bucket(index); entry != null; entry = (DictionaryEntry)entry.next()) {
            if (entry.hash() != hash || !entry.equals(className, classLoader)) continue;
            return entry;
        }
        return null;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Dictionary.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

