/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;

public class MemRegion
implements Cloneable {
    private Address start;
    private long byteSize;
    private static AddressField startField;
    private static CIntegerField wordSizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("MemRegion");
        startField = type.getAddressField("_start");
        wordSizeField = type.getCIntegerField("_word_size");
    }

    public MemRegion() {
    }

    public MemRegion(Address memRegionAddr) {
        this(startField.getValue(memRegionAddr), wordSizeField.getValue(memRegionAddr));
    }

    public MemRegion(Address start, long wordSize) {
        this.setStart(start);
        this.setWordSize(wordSize);
    }

    public MemRegion(Address start, Address limit) {
        this.setStart(start);
        this.byteSize = limit.minus(start);
    }

    public Object clone() {
        return new MemRegion(this.start, this.byteSize);
    }

    public MemRegion copy() {
        return (MemRegion)this.clone();
    }

    public MemRegion intersection(MemRegion mr2) {
        MemRegion res = new MemRegion();
        if (AddressOps.gt(mr2.start(), this.start())) {
            res.setStart(mr2.start());
        } else {
            res.setStart(this.start());
        }
        Address end = this.end();
        Address mr2End = mr2.end();
        Address resEnd = AddressOps.lt(end, mr2End) ? end : mr2End;
        if (AddressOps.lt(resEnd, res.start())) {
            res.setStart(null);
            res.setWordSize(0L);
        } else {
            res.setEnd(resEnd);
        }
        return res;
    }

    public MemRegion union(MemRegion mr2) {
        MemRegion res = new MemRegion();
        if (AddressOps.lt(mr2.start(), this.start())) {
            res.setStart(mr2.start());
        } else {
            res.setStart(this.start());
        }
        Address end = this.end();
        Address mr2End = mr2.end();
        Address resEnd = AddressOps.gt(end, mr2End) ? end : mr2End;
        res.setEnd(resEnd);
        return res;
    }

    public Address start() {
        return this.start;
    }

    public OopHandle startAsOopHandle() {
        return this.start().addOffsetToAsOopHandle(0L);
    }

    public Address end() {
        return this.start.addOffsetTo(this.byteSize);
    }

    public OopHandle endAsOopHandle() {
        return this.end().addOffsetToAsOopHandle(0L);
    }

    public void setStart(Address start) {
        this.start = start;
    }

    public void setEnd(Address end) {
        this.byteSize = end.minus(this.start);
    }

    public void setWordSize(long wordSize) {
        this.byteSize = VM.getVM().getAddressSize() * wordSize;
    }

    public boolean contains(MemRegion mr2) {
        return AddressOps.lte(this.start, mr2.start) && AddressOps.gte(this.end(), mr2.end());
    }

    public boolean contains(Address addr) {
        return AddressOps.gte(addr, this.start()) && AddressOps.lt(addr, this.end());
    }

    public long byteSize() {
        return this.byteSize;
    }

    public long wordSize() {
        return this.byteSize / VM.getVM().getAddressSize();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MemRegion.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

