/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import sun.security.util.DerValue;
import sun.security.util.ResourcesMgr;
import sun.security.x509.X500Name;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    public static final String CANONICAL = "CANONICAL";
    private transient X500Name thisX500Name;

    X500Principal(X500Name x500Name) {
        this.thisX500Name = x500Name;
    }

    public X500Principal(String string) {
        this(string, Collections.emptyMap());
    }

    public X500Principal(String string, Map<String, String> map) {
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("provided.null.name"));
        }
        if (map == null) {
            throw new NullPointerException(ResourcesMgr.getString("provided.null.keyword.map"));
        }
        try {
            this.thisX500Name = new X500Name(string, map);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public X500Principal(byte[] byArray) {
        try {
            this.thisX500Name = new X500Name(byArray);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public X500Principal(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("provided null input stream");
        }
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available() + 1);
            }
            DerValue derValue = new DerValue(inputStream);
            this.thisX500Name = new X500Name(derValue.data);
        }
        catch (Exception exception) {
            if (inputStream.markSupported()) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream and unable to reset input stream");
                    illegalArgumentException.initCause(exception);
                    throw illegalArgumentException;
                }
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    @Override
    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(RFC1779)) {
                return this.thisX500Name.getRFC1779Name();
            }
            if (string.equalsIgnoreCase(RFC2253)) {
                return this.thisX500Name.getRFC2253Name();
            }
            if (string.equalsIgnoreCase(CANONICAL)) {
                return this.thisX500Name.getRFC2253CanonicalName();
            }
        }
        throw new IllegalArgumentException("invalid format specified");
    }

    public String getName(String string, Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException(ResourcesMgr.getString("provided.null.OID.map"));
        }
        if (string != null) {
            if (string.equalsIgnoreCase(RFC1779)) {
                return this.thisX500Name.getRFC1779Name(map);
            }
            if (string.equalsIgnoreCase(RFC2253)) {
                return this.thisX500Name.getRFC2253Name(map);
            }
        }
        throw new IllegalArgumentException("invalid format specified");
    }

    public byte[] getEncoded() {
        try {
            return this.thisX500Name.getEncoded();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to get encoding", iOException);
        }
    }

    @Override
    public String toString() {
        return this.thisX500Name.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X500Principal)) {
            return false;
        }
        X500Principal x500Principal = (X500Principal)object;
        return this.thisX500Name.equals(x500Principal.thisX500Name);
    }

    @Override
    public int hashCode() {
        return this.thisX500Name.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.thisX500Name.getEncodedInternal());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        this.thisX500Name = new X500Name((byte[])objectInputStream.readObject());
    }
}

