/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

final class KeyProtector {
    private static final int SALT_LEN = 20;
    private static final String DIGEST_ALG = "SHA";
    private static final int DIGEST_LEN = 20;
    private static final String KEY_PROTECTOR_OID = "1.3.6.1.4.1.42.2.17.1.1";
    private byte[] passwdBytes;
    private MessageDigest md;

    public KeyProtector(byte[] byArray) throws NoSuchAlgorithmException {
        if (byArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        this.md = MessageDigest.getInstance(DIGEST_ALG);
        this.passwdBytes = byArray;
    }

    protected void finalize() {
        if (this.passwdBytes != null) {
            Arrays.fill(this.passwdBytes, (byte)0);
            this.passwdBytes = null;
        }
    }

    public byte[] protect(Key key) throws KeyStoreException {
        int n = 0;
        if (key == null) {
            throw new IllegalArgumentException("plaintext key can't be null");
        }
        if (!"PKCS#8".equalsIgnoreCase(key.getFormat())) {
            throw new KeyStoreException("Cannot get key bytes, not PKCS#8 encoded");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyStoreException("Cannot get key bytes, encoding not supported");
        }
        int n2 = byArray.length / 20;
        if (byArray.length % 20 != 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[20];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[byArray.length];
        int n3 = 0;
        int n4 = 0;
        byte[] byArray4 = byArray2;
        while (n3 < n2) {
            this.md.update(this.passwdBytes);
            this.md.update(byArray4);
            byArray4 = this.md.digest();
            this.md.reset();
            if (n3 < n2 - 1) {
                System.arraycopy(byArray4, 0, byArray3, n4, byArray4.length);
            } else {
                System.arraycopy(byArray4, 0, byArray3, n4, byArray3.length - n4);
            }
            ++n3;
            n4 += 20;
        }
        byte[] byArray5 = new byte[byArray.length];
        for (n3 = 0; n3 < byArray5.length; ++n3) {
            byArray5[n3] = (byte)(byArray[n3] ^ byArray3[n3]);
        }
        byte[] byArray6 = new byte[byArray2.length + byArray5.length + 20];
        System.arraycopy(byArray2, 0, byArray6, n, byArray2.length);
        System.arraycopy(byArray5, 0, byArray6, n += byArray2.length, byArray5.length);
        n += byArray5.length;
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(byArray);
        byArray4 = this.md.digest();
        this.md.reset();
        System.arraycopy(byArray4, 0, byArray6, n, byArray4.length);
        try {
            AlgorithmId algorithmId = new AlgorithmId(new ObjectIdentifier(KEY_PROTECTOR_OID));
            return new EncryptedPrivateKeyInfo(algorithmId, byArray6).getEncoded();
        }
        catch (IOException iOException) {
            throw new KeyStoreException(iOException.getMessage());
        }
    }

    public Key recover(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) throws UnrecoverableKeyException {
        AlgorithmId algorithmId = encryptedPrivateKeyInfo.getAlgorithm();
        if (!algorithmId.getOID().toString().equals(KEY_PROTECTOR_OID)) {
            throw new UnrecoverableKeyException("Unsupported key protection algorithm");
        }
        byte[] byArray = encryptedPrivateKeyInfo.getEncryptedData();
        byte[] byArray2 = new byte[20];
        System.arraycopy(byArray, 0, byArray2, 0, 20);
        int n = byArray.length - 20 - 20;
        int n2 = n / 20;
        if (n % 20 != 0) {
            ++n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 20, byArray3, 0, n);
        byte[] byArray4 = new byte[byArray3.length];
        int n3 = 0;
        int n4 = 0;
        byte[] byArray5 = byArray2;
        while (n3 < n2) {
            this.md.update(this.passwdBytes);
            this.md.update(byArray5);
            byArray5 = this.md.digest();
            this.md.reset();
            if (n3 < n2 - 1) {
                System.arraycopy(byArray5, 0, byArray4, n4, byArray5.length);
            } else {
                System.arraycopy(byArray5, 0, byArray4, n4, byArray4.length - n4);
            }
            ++n3;
            n4 += 20;
        }
        byte[] byArray6 = new byte[byArray3.length];
        for (n3 = 0; n3 < byArray6.length; ++n3) {
            byArray6[n3] = (byte)(byArray3[n3] ^ byArray4[n3]);
        }
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(byArray6);
        byArray5 = this.md.digest();
        this.md.reset();
        for (n3 = 0; n3 < byArray5.length; ++n3) {
            if (byArray5[n3] == byArray[20 + n + n3]) continue;
            throw new UnrecoverableKeyException("Cannot recover key");
        }
        try {
            return PKCS8Key.parseKey(new DerValue(byArray6));
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException(iOException.getMessage());
        }
    }
}

