/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.consumer.ChunkParser;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;
import jdk.jfr.internal.consumer.RecordingInternals;

public final class RecordingFile
implements Closeable {
    private boolean isLastEventInChunk;
    private final File file;
    private RecordingInput input;
    private ChunkParser chunkParser;
    private RecordedEvent nextEvent;
    private boolean eof;

    public RecordingFile(Path path) throws IOException {
        this.file = path.toFile();
        this.input = new RecordingInput(this.file);
        this.findNext();
    }

    public RecordedEvent readEvent() throws IOException {
        if (this.eof) {
            this.ensureOpen();
            throw new EOFException();
        }
        this.isLastEventInChunk = false;
        RecordedEvent recordedEvent = this.nextEvent;
        this.nextEvent = this.chunkParser.readEvent();
        if (this.nextEvent == null) {
            this.isLastEventInChunk = true;
            this.findNext();
        }
        return recordedEvent;
    }

    public boolean hasMoreEvents() {
        return !this.eof;
    }

    public List<EventType> readEventTypes() throws IOException {
        this.ensureOpen();
        ArrayList<EventType> arrayList = new ArrayList<EventType>();
        HashSet<Long> hashSet = new HashSet<Long>();
        try (RecordingInput recordingInput = new RecordingInput(this.file);){
            ChunkHeader chunkHeader = new ChunkHeader(recordingInput);
            RecordingFile.aggregateEventTypeForChunk(chunkHeader, arrayList, hashSet);
            while (!chunkHeader.isLastChunk()) {
                chunkHeader = chunkHeader.nextHeader();
                RecordingFile.aggregateEventTypeForChunk(chunkHeader, arrayList, hashSet);
            }
        }
        return arrayList;
    }

    List<Type> readTypes() throws IOException {
        this.ensureOpen();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        HashSet<Long> hashSet = new HashSet<Long>();
        try (RecordingInput recordingInput = new RecordingInput(this.file);){
            ChunkHeader chunkHeader = new ChunkHeader(recordingInput);
            this.aggregateTypeForChunk(chunkHeader, arrayList, hashSet);
            while (!chunkHeader.isLastChunk()) {
                chunkHeader = chunkHeader.nextHeader();
                this.aggregateTypeForChunk(chunkHeader, arrayList, hashSet);
            }
        }
        return arrayList;
    }

    private void aggregateTypeForChunk(ChunkHeader chunkHeader, List<Type> list, HashSet<Long> hashSet) throws IOException {
        MetadataDescriptor metadataDescriptor = chunkHeader.readMetadata();
        for (Type type : metadataDescriptor.getTypes()) {
            if (hashSet.contains(type.getId())) continue;
            list.add(type);
            hashSet.add(type.getId());
        }
    }

    private static void aggregateEventTypeForChunk(ChunkHeader chunkHeader, List<EventType> list, HashSet<Long> hashSet) throws IOException {
        MetadataDescriptor metadataDescriptor = chunkHeader.readMetadata();
        for (EventType eventType : metadataDescriptor.getEventTypes()) {
            if (hashSet.contains(eventType.getId())) continue;
            list.add(eventType);
            hashSet.add(eventType.getId());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.eof = true;
            this.input.close();
            this.chunkParser = null;
            this.input = null;
            this.nextEvent = null;
        }
    }

    public static List<RecordedEvent> readAllEvents(Path path) throws IOException {
        try (RecordingFile recordingFile = new RecordingFile(path);){
            ArrayList<RecordedEvent> arrayList = new ArrayList<RecordedEvent>();
            while (recordingFile.hasMoreEvents()) {
                arrayList.add(recordingFile.readEvent());
            }
            ArrayList<RecordedEvent> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void findNext() throws IOException {
        while (this.nextEvent == null) {
            if (this.chunkParser == null) {
                this.chunkParser = new ChunkParser(this.input);
            } else if (!this.chunkParser.isLastChunk()) {
                this.chunkParser = this.chunkParser.nextChunkParser();
            } else {
                this.eof = true;
                return;
            }
            this.nextEvent = this.chunkParser.readEvent();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.input == null) {
            throw new IOException("Stream Closed");
        }
    }

    static {
        RecordingInternals.INSTANCE = new RecordingInternals(){

            @Override
            public List<Type> readTypes(RecordingFile recordingFile) throws IOException {
                return recordingFile.readTypes();
            }

            @Override
            public boolean isLastEventInChunk(RecordingFile recordingFile) {
                return recordingFile.isLastEventInChunk;
            }

            @Override
            public Object getOffsetDataTime(RecordedObject recordedObject, String string) {
                return recordedObject.getOffsetDateTime(string);
            }

            @Override
            public void sort(List<RecordedEvent> list) {
                Collections.sort(list, (recordedEvent, recordedEvent2) -> Long.compare(recordedEvent.endTime, recordedEvent2.endTime));
            }
        };
    }
}

