/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11ECUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

final class P11ECKeyFactory
extends P11KeyFactory {
    private static Provider sunECprovider;

    private static Provider getSunECProvider() {
        if (sunECprovider == null && (sunECprovider = Security.getProvider("SunEC")) == null) {
            throw new RuntimeException("Cannot load SunEC provider");
        }
        return sunECprovider;
    }

    P11ECKeyFactory(Token token, String string) {
        super(token, string);
    }

    static ECParameterSpec getECParameterSpec(String string) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), string);
    }

    static ECParameterSpec getECParameterSpec(int n) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), n);
    }

    static ECParameterSpec getECParameterSpec(ECParameterSpec eCParameterSpec) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), eCParameterSpec);
    }

    static ECParameterSpec decodeParameters(byte[] byArray) throws IOException {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), byArray);
    }

    static byte[] encodeParameters(ECParameterSpec eCParameterSpec) {
        return ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), eCParameterSpec);
    }

    static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        return ECUtil.decodePoint(byArray, ellipticCurve);
    }

    static byte[] getEncodedPublicValue(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECPoint eCPoint = eCPublicKey.getW();
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            return ECUtil.encodePoint(eCPoint, eCParameterSpec.getCurve());
        }
        throw new InvalidKeyException("Key class not yet supported: " + publicKey.getClass().getName());
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            if (publicKey instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
                return this.generatePublic(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            if ("X.509".equals(publicKey.getFormat())) {
                byte[] byArray = publicKey.getEncoded();
                try {
                    publicKey = P11ECUtil.decodeX509ECPublicKey(byArray);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new InvalidKeyException(invalidKeySpecException);
                }
                return this.implTranslatePublicKey(publicKey);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create EC public key", pKCS11Exception);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (privateKey instanceof ECPrivateKey) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                return this.generatePrivate(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            if ("PKCS#8".equals(privateKey.getFormat())) {
                byte[] byArray = privateKey.getEncoded();
                try {
                    privateKey = P11ECUtil.decodePKCS8ECPrivateKey(byArray);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new InvalidKeyException(invalidKeySpecException);
                }
                return this.implTranslatePrivateKey(privateKey);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create EC private key", pKCS11Exception);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKey eCPublicKey = P11ECUtil.decodeX509ECPublicKey(byArray);
                return this.implTranslatePublicKey(eCPublicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("Could not create EC public key", invalidKeyException);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(eCPublicKeySpec.getW(), eCPublicKeySpec.getParams());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create EC public key", pKCS11Exception);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey eCPrivateKey = P11ECUtil.decodePKCS8ECPrivateKey(byArray);
                return this.implTranslatePrivateKey(eCPrivateKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create EC private key", generalSecurityException);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(eCPrivateKeySpec.getS(), eCPrivateKeySpec.getParams());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create EC private key", pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws PKCS11Exception {
        byte[] byArray = ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), eCParameterSpec);
        byte[] byArray2 = ECUtil.encodePoint(eCPoint, eCParameterSpec.getCurve());
        if (!this.token.config.getUseEcX963Encoding()) {
            try {
                byArray2 = new DerValue(4, byArray2).toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Could not DER encode point", iOException);
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(385L, byArray2), new CK_ATTRIBUTE(384L, byArray)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 2L, 3L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey(session, l, "EC", eCParameterSpec.getCurve().getField().getFieldSize(), cK_ATTRIBUTEArray);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws PKCS11Exception {
        byte[] byArray = ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(384L, byArray)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 3L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l, "EC", eCParameterSpec.getCurve().getField().getFieldSize(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    <T extends KeySpec> T implGetPublicKeySpec(P11Key p11Key, Class<T> clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (clazz.isAssignableFrom(ECPublicKeySpec.class)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            long l = p11Key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(sessionArray[0].id(), l, cK_ATTRIBUTEArray);
                ECParameterSpec eCParameterSpec = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
                ECPoint eCPoint = P11ECKeyFactory.decodePoint(cK_ATTRIBUTEArray[0].getByteArray(), eCParameterSpec.getCurve());
                KeySpec keySpec = (KeySpec)clazz.cast(new ECPublicKeySpec(eCPoint, eCParameterSpec));
                return (T)keySpec;
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Could not parse key", iOException);
            }
            finally {
                p11Key.releaseKeyID();
            }
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    @Override
    <T extends KeySpec> T implGetPrivateKeySpec(P11Key p11Key, Class<T> clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (clazz.isAssignableFrom(ECPrivateKeySpec.class)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L)};
            long l = p11Key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(sessionArray[0].id(), l, cK_ATTRIBUTEArray);
                ECParameterSpec eCParameterSpec = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
                KeySpec keySpec = (KeySpec)clazz.cast(new ECPrivateKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), eCParameterSpec));
                return (T)keySpec;
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Could not parse key", iOException);
            }
            finally {
                p11Key.releaseKeyID();
            }
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("EC", P11ECKeyFactory.getSunECProvider());
    }
}

