/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSContextImpl;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public class GSSManagerImpl
extends GSSManager {
    private static final String USE_NATIVE_PROP = "sun.security.jgss.native";
    private static final Boolean USE_NATIVE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.valueOf(System.getProperty(GSSManagerImpl.USE_NATIVE_PROP));
        }
    });
    private ProviderList list;

    public GSSManagerImpl(GSSCaller gSSCaller, boolean bl) {
        this.list = new ProviderList(gSSCaller, bl);
    }

    public GSSManagerImpl(GSSCaller gSSCaller) {
        this.list = new ProviderList(gSSCaller, USE_NATIVE);
    }

    public GSSManagerImpl() {
        this.list = new ProviderList(GSSCaller.CALLER_UNKNOWN, USE_NATIVE);
    }

    @Override
    public Oid[] getMechs() {
        return this.list.getMechs();
    }

    @Override
    public Oid[] getNamesForMech(Oid oid) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return (Oid[])mechanismFactory.getNameTypes().clone();
    }

    @Override
    public Oid[] getMechsForName(Oid oid) {
        Oid[] oidArray = this.list.getMechs();
        Oid[] oidArray2 = new Oid[oidArray.length];
        int n = 0;
        if (oid.equals(GSSNameImpl.oldHostbasedServiceName)) {
            oid = GSSName.NT_HOSTBASED_SERVICE;
        }
        for (int i = 0; i < oidArray.length; ++i) {
            Oid oid2 = oidArray[i];
            try {
                Oid[] oidArray3 = this.getNamesForMech(oid2);
                if (!oid.containedIn(oidArray3)) continue;
                oidArray2[n++] = oid2;
                continue;
            }
            catch (GSSException gSSException) {
                GSSUtil.debug("Skip " + oid2 + ": error retrieving supported name types");
            }
        }
        if (n < oidArray2.length) {
            Oid[] oidArray4 = new Oid[n];
            for (int i = 0; i < n; ++i) {
                oidArray4[i] = oidArray2[i];
            }
            oidArray2 = oidArray4;
        }
        return oidArray2;
    }

    @Override
    public GSSName createName(String string, Oid oid) throws GSSException {
        return new GSSNameImpl(this, string, oid);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new GSSNameImpl(this, byArray, oid);
    }

    @Override
    public GSSName createName(String string, Oid oid, Oid oid2) throws GSSException {
        return new GSSNameImpl(this, string, oid, oid2);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        return new GSSNameImpl(this, byArray, oid, oid2);
    }

    @Override
    public GSSCredential createCredential(int n) throws GSSException {
        return new GSSCredentialImpl(this, n);
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        return new GSSCredentialImpl(this, gSSName, n, oid, n2);
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        return new GSSCredentialImpl(this, gSSName, n, oidArray, n2);
    }

    @Override
    public GSSContext createContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        return new GSSContextImpl(this, gSSName, oid, gSSCredential, n);
    }

    @Override
    public GSSContext createContext(GSSCredential gSSCredential) throws GSSException {
        return new GSSContextImpl(this, gSSCredential);
    }

    @Override
    public GSSContext createContext(byte[] byArray) throws GSSException {
        return new GSSContextImpl(this, byArray);
    }

    @Override
    public void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        this.list.addProviderAtFront(provider, oid);
    }

    @Override
    public void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        this.list.addProviderAtEnd(provider, oid);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, Oid oid, int n3) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid);
        return mechanismFactory.getCredentialElement(gSSNameSpi, n, n2, n3);
    }

    public GSSNameSpi getNameElement(String string, Oid oid, Oid oid2) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid2);
        return mechanismFactory.getNameElement(string, oid);
    }

    public GSSNameSpi getNameElement(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid2);
        return mechanismFactory.getNameElement(byArray, oid);
    }

    GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n, Oid oid) throws GSSException {
        Provider provider = null;
        if (gSSCredentialSpi != null) {
            provider = gSSCredentialSpi.getProvider();
        }
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid, provider);
        return mechanismFactory.getMechanismContext(gSSNameSpi, gSSCredentialSpi, n);
    }

    GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi, Oid oid) throws GSSException {
        Provider provider = null;
        if (gSSCredentialSpi != null) {
            provider = gSSCredentialSpi.getProvider();
        }
        MechanismFactory mechanismFactory = this.list.getMechFactory(oid, provider);
        return mechanismFactory.getMechanismContext(gSSCredentialSpi);
    }

    GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        MechanismFactory mechanismFactory;
        if (byArray == null || byArray.length == 0) {
            throw new GSSException(12);
        }
        GSSContextSpi gSSContextSpi = null;
        Oid[] oidArray = this.list.getMechs();
        for (int i = 0; !(i >= oidArray.length || (mechanismFactory = this.list.getMechFactory(oidArray[i])).getProvider().getName().equals("SunNativeGSS") && (gSSContextSpi = mechanismFactory.getMechanismContext(byArray)) != null); ++i) {
        }
        if (gSSContextSpi == null) {
            throw new GSSException(16);
        }
        return gSSContextSpi;
    }
}

