/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private DefaultSelectorProvider() {
    }

    private static SelectorProvider createProvider(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        try {
            return (SelectorProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    public static SelectorProvider create() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.equals("SunOS")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.DevPollSelectorProvider");
        }
        if (string.equals("Linux")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.EPollSelectorProvider");
        }
        return new PollSelectorProvider();
    }
}

