/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.consumer.ConstantMap;
import jdk.jfr.consumer.EventParser;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.ParserFactory;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;

final class ChunkParser {
    private static final long CONSTANT_POOL_TYPE_ID = 1L;
    private final RecordingInput input;
    private final LongMap<Parser> parsers;
    private final ChunkHeader chunkHeader;
    private final long absoluteChunkEnd;
    private final MetadataDescriptor metadata;
    private final LongMap<Type> typeMap;
    private final TimeConverter timeConverter;

    public ChunkParser(RecordingInput recordingInput) throws IOException {
        this(new ChunkHeader(recordingInput));
    }

    private ChunkParser(ChunkHeader chunkHeader) throws IOException {
        this.input = chunkHeader.getInput();
        this.chunkHeader = chunkHeader;
        this.metadata = chunkHeader.readMetadata();
        this.absoluteChunkEnd = chunkHeader.getEnd();
        this.timeConverter = new TimeConverter(this.chunkHeader, this.metadata.getGMTOffset());
        ParserFactory parserFactory = new ParserFactory(this.metadata, this.timeConverter);
        LongMap<ConstantMap> longMap = parserFactory.getConstantPools();
        this.parsers = parserFactory.getParsers();
        this.typeMap = parserFactory.getTypeMap();
        this.fillConstantPools(this.parsers, longMap);
        longMap.forEach(ConstantMap::setIsResolving);
        longMap.forEach(ConstantMap::resolve);
        longMap.forEach(ConstantMap::setResolved);
        this.input.position(this.chunkHeader.getEventStart());
    }

    public RecordedEvent readEvent() throws IOException {
        while (this.input.position() < this.absoluteChunkEnd) {
            Parser parser;
            long l = this.input.position();
            int n = this.input.readInt();
            if (n == 0) {
                throw new IOException("Event can't have zero size");
            }
            long l2 = this.input.readLong();
            if (l2 > 1L && (parser = this.parsers.get(l2)) instanceof EventParser) {
                return (RecordedEvent)parser.parse(this.input);
            }
            this.input.position(l + (long)n);
        }
        return null;
    }

    private void fillConstantPools(LongMap<Parser> longMap, LongMap<ConstantMap> longMap2) throws IOException {
        long l = this.chunkHeader.getAbsoluteChunkStart();
        long l2 = this.chunkHeader.getConstantPoolPosition();
        while (l2 != 0L) {
            this.input.position(l += l2);
            long l3 = l;
            int n = this.input.readInt();
            long l4 = this.input.readLong();
            if (l4 != 1L) {
                throw new IOException("Expected check point event (id = 1) at position " + l + ", but found type id = " + l4);
            }
            this.input.readLong();
            this.input.readLong();
            long l5 = l2 = this.input.readLong();
            boolean bl = this.input.readBoolean();
            int n2 = this.input.readInt();
            Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE, () -> "New constant pool: startPosition=" + l3 + ", size=" + n + ", deltaToNext=" + l5 + ", flush=" + bl + ", poolCount=" + n2);
            for (int i = 0; i < n2; ++i) {
                Parser parser;
                long l6 = this.input.readLong();
                ConstantMap constantMap = longMap2.get(l6);
                Type type = this.typeMap.get(l6);
                if (constantMap == null) {
                    Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.INFO, "Found constant pool(" + l6 + ") that is never used");
                    if (type == null) {
                        throw new IOException("Error parsing constant pool type " + this.getName(l6) + " at position " + this.input.position() + " at check point between [" + l + ", " + l + n + "]");
                    }
                    constantMap = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                    longMap2.put(type.getId(), constantMap);
                }
                if ((parser = longMap.get(l6)) == null) {
                    throw new IOException("Could not find constant pool type with id = " + l6);
                }
                try {
                    int n3 = this.input.readInt();
                    Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE, () -> "Constant: " + this.getName(l6) + "[" + n3 + "]");
                    for (int j = 0; j < n3; ++j) {
                        long l7 = this.input.readLong();
                        Object object = parser.parse(this.input);
                        constantMap.put(l7, object);
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new IOException("Error parsing constant pool type " + this.getName(l6) + " at position " + this.input.position() + " at check point between [" + l + ", " + l + n + "]", exception);
                }
            }
            if (this.input.position() == l + (long)n) continue;
            throw new IOException("Size of check point event doesn't match content");
        }
    }

    private String getName(long l) {
        Type type = this.typeMap.get(l);
        return type == null ? "unknown(" + l + ")" : type.getName();
    }

    public Collection<Type> getTypes() {
        return this.metadata.getTypes();
    }

    public List<EventType> getEventTypes() {
        return this.metadata.getEventTypes();
    }

    public boolean isLastChunk() {
        return this.chunkHeader.isLastChunk();
    }

    public ChunkParser nextChunkParser() throws IOException {
        return new ChunkParser(this.chunkHeader.nextHeader());
    }
}

